#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

class AccesskeyWindow < Gtk::HBox

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    register_sigint
    reset
    @v_box_entries = Gtk::VBox.new(false, 6)
    @v_box_entries.pack_start(get_menu_bar, true)
    add_gtk_entries
    add(@v_box_entries).show_all
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # ========================================================================= #
    # === @entries
    # ========================================================================= #
    @entries = [] # We store the gtk entries here.
  end

  # ========================================================================= #
  # === add_gtk_entries
  #
  # Add the 5 gtk entries next.
  # ========================================================================= #
  def add_gtk_entries
    5.times { |this_number| # Add 5 gtk-entries next.
      entry = Gtk::Entry.new
      entry.set_text(
        'Use alt+NUMBER (alt+'+(this_number+1).to_s+') to jump'
      )
      @entries << entry
      @v_box_entries.pack_start(@entries[this_number], false, false, 2)
    }
  end

  # ========================================================================= #
  # === accel_group
  # ========================================================================= #
  def accel_group
    @accel_group
  end

  # ========================================================================= #
  # === register_sigint
  # ========================================================================= #
  def register_sigint
    Signal.trap('SIGINT') { exit }
  end

  # ========================================================================= #
  # === get_menu_bar
  #
  # Creates the menu bar.
  # ========================================================================= #
  def get_menu_bar
    @accel_group = Gtk::AccelGroup.new
    @menu = Gtk::ItemFactory.new(
      Gtk::ItemFactory::TYPE_MENU_BAR, '<main>', @accel_group
    )
    proc_activate_menu = Proc.new { |data, wiget|
      my_menu_activate(
        Gtk::ItemFactory.path_from_widget(wiget)
      ) # menu-pfad
    }
    array_my_items = [
      [ '/Entry/entry0', '<Item>', '<alt>1', nil, proc_activate_menu ],
      [ '/Entry/entry1', '<Item>', '<alt>2', nil, proc_activate_menu ],
      [ '/Entry/entry2', '<Item>', '<alt>3', nil, proc_activate_menu ],
      [ '/Entry/entry3', '<Item>', '<alt>4', nil, proc_activate_menu ],
      [ '/Entry/entry4', '<Item>', '<alt>5', nil, proc_activate_menu ],
    ]
    @menu.create_items(array_my_items)
    return @menu.get_widget('<main>')
  end

  # ========================================================================= #
  # === entry?
  # ========================================================================= #
  def entry?
    @entries
  end

  # ========================================================================= #
  # === focus_entry
  # ========================================================================= #
  def focus_entry(position = 1)
    @entries[position.to_i - 1].set_focus(true) 
  end

  # ========================================================================= #
  # === my_menu_activate
  #
  # Activate our menu
  # ========================================================================= #
  def my_menu_activate(i)
    if i.include? 'entry'
      e = i[ ( i.length - 1 ) ... i.length ] # Last element.
      entry?[ e.to_i ].set_focus(true)
    end
  end

  # ========================================================================= #
  # === width?
  # ========================================================================= #
  def width?
    960
  end

end

if __FILE__ == $PROGRAM_NAME
  r = Gtk::Window.new
  acesskey_window = AccesskeyWindow.new
  r.add(acesskey_window)
  r.add_accel_group(acesskey_window.accel_group)
  # r.add_shortcut(1, 'focus_entry(1)', :alt)
  # r.add_shortcut(2, 'focus_entry(2)', :alt)
  # r.add_shortcut(3, 'focus_entry(3)', :alt)
  # r.add_shortcut(4, 'focus_entry(4)', :alt)
  # r.add_shortcut(5, 'focus_entry(5)', :alt)
  r.show_all
  r.move(0, 0)
  Gtk.main
end # $RUBY_GTK/accesskeys_demonstration.rb