#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This works fine in both gtk2 and gtk3.
# =========================================================================== #
require 'gtk2'

LOGO_TO_USE = '/home/Programs/Ruby/Current/lib/ruby/gems/2.7.0/cache/gtk3-3.4.3.gem/sample/misc/gnome-logo-icon.png'

Gtk::AboutDialog.set_email_hook {|about, link| p 'This is the email.'; p link }
Gtk::AboutDialog.set_url_hook   {|about, link| p 'url_hook'; p link }

a = Gtk::AboutDialog.new
a.artists     = ['Artist 1 <no1@foo.bar.com>', 'Artist 2 <no2@foo.bar.com>']
a.authors     = ['Author 1 <no1@foo.bar.com>', 'Author 2 <no2@foo.bar.com>']
a.comments    = 'This is a sample script for Gtk::AboutDialog'
a.copyright   = 'Copyright (C) 2020 Ruby-GNOME2 Project'
a.documenters = ['Documenter name 1 <no1@foo.bar.com>', 'Documenter 2 <no2@foo.bar.com>']
a.license     = 'This program is licenced under the same licence as Ruby-GNOME2.'
a.logo        = Gdk::Pixbuf.new(file: LOGO_TO_USE) if File.exist? LOGO_TO_USE
a.name        = 'Gtk::AboutDialog sample'
a.translator_credits = "Written by Roebe.\n"
a.version     = '1.0.0'
a.website     = 'https://ruby-gnome2.sourceforge.jp'
a.website_label = 'Ruby-GNOME2 Project Website'
a.set_size_request(600, 400)
p a.run # to run the about dialog.
# rb $RUBY_GTK/aboutdialog.rb