#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

alias e puts

names = %w(
  Andrew Tim Samantha
  Jonathan Joe Jack
  Tom Jerry Spud
)

window = Gtk::Window.new
window.set_border_width(20)
window.set_size_request(800, -1)
window.set_title('Vertical Boxes')
window.move(0, 0)

box = Gtk::VBox.new

names.each {|name|
  button = Gtk::Button.new(name, true)
  box.pack_start(button, true, true, 0)
  button.signal_connect(:clicked) {
    e "Hello #{name}!"
  }
  button.set_relief(:normal)
}

window.add(box)
window.show_all
Gtk.main