#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# Also features two windows.
# =========================================================================== #
require 'gtk2'

class DragWindow < Gtk::Window

  alias e puts

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 200

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super('Source Window')
    @label = Gtk::Label.new('Drag here!')
    add(@label)
    set_default_size(WIDTH, 250)

    Gtk::Drag.source_set(self, 
      Gdk::Window::BUTTON1_MASK | Gdk::Window::BUTTON2_MASK,
      [['test', Gtk::Drag::TARGET_SAME_APP, 12345]], 
        Gdk::DragContext::ACTION_COPY | 
        Gdk::DragContext::ACTION_MOVE
    )
    signal_connect(:drag_data_get) { |widget, context, selection_data, info, time|
      # selection_data.set("text/uri-list", 8, "hoge.txt")
      e ':drag_data_get signal was received.'
      # ===================================================================== #
      # Next we can set a string for the selection-data:
      # ===================================================================== #
      selection_data.set(Gdk::Selection::TYPE_STRING, 'hoge.txt')  
    }
    move(0, 0)
  end

end

# =========================================================================== #
# The next class, DropWindow, is the target of the drag-event specified
# above.
# =========================================================================== #
class DropWindow < Gtk::Window

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super('Dest Window')
    create_gtk_label
    add(@label)
    set_default_size(120, 120)

    Gtk::Drag.dest_set(self, 
       Gtk::Drag::DEST_DEFAULT_MOTION | Gtk::Drag::DEST_DEFAULT_HIGHLIGHT,
       [ ['test', Gtk::Drag::TARGET_SAME_APP, 12345] ], 
       Gdk::DragContext::ACTION_COPY|Gdk::DragContext::ACTION_MOVE
    )

    signal_connect(:drag_data_received) { |w, dc, x, y, selection_data, info, time|
      dc.targets.each { |target|
        if target.name == 'test' ||
           selection_data.type == Gdk::Selection::TYPE_STRING
          puts 'The data was: '+selection_data.data # Otain the dataset here.
        end
      }
    }

    signal_connect(:drag_drop) { |w, dc, x, y, time|
      puts ' ==> Drag-drop signal was received.'
      Gtk::Drag.get_data(w, dc, dc.targets[0], time)
    }
  end

  # ========================================================================= #
  # === create_gtk_label
  # ========================================================================= #
  def create_gtk_label
    @label = Gtk::Label.new('Drop here!')
  end

end

if __FILE__ == $PROGRAM_NAME
  win1 = DragWindow.new
  win2 = DropWindow.new
  win1.show_all.signal_connect(:destroy) { Gtk.main_quit }
  win2.show_all.signal_connect(:destroy) { Gtk.main_quit }
  Gtk.main
end