#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This wills how two icons - a random entry on the left side, and a
# determined value on the right side. We deliberately keep this example
# simple, so that people can re-use the code as-is.
# =========================================================================== #
require 'gtk2'
alias e puts

window = Gtk::Window.new(:toplevel)
window.realize

sample = Gtk::Stock.constants.sample
sample = 'ZOOM_IN'

target = "gtk-#{sample.downcase}".tr('_','-').to_sym # This ought to be a symbol.

hbox = Gtk::HBox.new
image1 = Gtk::Image.new
e
e 'The available GTK-Icons are:'
e
p Gtk::Stock.constants.sort
image1.set(target, Gtk::IconSize::MENU)
mini_vbox1 = Gtk::VBox.new
mini_vbox1.add(image1)
mini_vbox1.pack_start(Gtk::Label.new(target.to_s), true, true)
hbox.add(mini_vbox1)

image2 = Gtk::Image.new
image2.set(:'gtk-close', Gtk::IconSize::MENU)
hbox.add(image2)
window.add(hbox)
window.show_all
window.move(0, 0)
window.set_size_request(500, 200)
Gtk.main