#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

enum = GLib::Param::Enum.new(
   'enum',                      # name
   'Enum',                      # nick
   'Enum enum',                 # blurb
   GLib::Type['GdkCursorType'], #type
   Gdk::Cursor::ARROW,          #default
   GLib::Param::READABLE|
   GLib::Param::WRITABLE
)

flags = GLib::Param::Flags.new(
  'flags',                       # name
  'Flags',                       # nick
  'Flags flags',                 # blurb
  GLib::Type['GdkEventMask'],    #type
  Gdk::Event::LEAVE_NOTIFY_MASK, #default
  GLib::Param::READABLE|
  GLib::Param::WRITABLE
)

spec = GLib::Param::Int.new('integer',         # name
  'Integer',         # nick
  'Integer integer', # blurb
  0,                 # min
  10000,             # max
  0,                 # default
  GLib::Param::READABLE|
  GLib::Param::WRITABLE
)

p Gtk::Settings.rc_property_parse_enum(enum, 'watch')
p Gtk::Settings.rc_property_parse_flags(flags, "(scroll-mask|structure-mask)")
p Gtk::Settings.rc_property_parse_requisition(spec, "{100, 200}")
p Gtk::Settings.rc_property_parse_border(spec, "{100, 200, 300, 400}").to_a