#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ButtonsShowcasingTheRelief
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/018_buttons_showcasing_the_relief.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class ButtonsShowcasingTheRelief < ::Gtk::Box

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:horizontal, 0)

    # ======================================================================= #
    # === The first button
    # ======================================================================= #
    button1 = ::Gtk::Button.new
    button1.label = 'Button #1 RELIEF_HALF'
    button1.signal_connect(:clicked) { puts 'Hello world!' }
    button1.relief = :half

    # ======================================================================= #
    # === The second button
    # ======================================================================= #
    button2 = ::Gtk::Button.new
    button2.label = 'Button #2 RELIEF_NONE'
    button2.signal_connect(:clicked) { puts 'Hello world!' }
    button2.relief = :none

    # ======================================================================= #
    # === The third button
    # ======================================================================= #
    button3 = ::Gtk::Button.new
    button3.label = 'Button #3 RELIEF_NORMAL'
    button3.signal_connect(:clicked) { puts 'Hello world!' }
    button3.relief = :normal
    pack_start(button1, expand: true, fill: true, padding: 5)
    pack_start(button2, expand: true, fill: true, padding: 5)
    pack_start(button3, expand: true, fill: true, padding: 5)
    set_border_width(5)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  buttons_showcasing_the_relief = Gtk::ButtonsShowcasingTheRelief.new
  window.add(buttons_showcasing_the_relief)
  window.show_all
  window.move(0, 0)
  window.set_size_request(800, 200)
  window.signal_connect(:delete_event) { Gtk.main_quit }
  Gtk.main  
end