#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This example shows how to use pixbuf-icons in a treeview.
# =========================================================================== #
require 'gtk3'

class CellRendererPixbufWindow < Gtk::Window

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super('CellRendererPixbuf Example')
    run if run_already
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    set_default_size(200, 200)
    @liststore = Gtk::ListStore.new(String, String)
    iter = @liststore.append
    iter.set_value(0, 'New')
    iter.set_value(1, 'document-new')
    iter = @liststore.append
    iter.set_value(0, 'Open')
    iter.set_value(1, 'document-open')
    iter = @liststore.append
    iter.set_value(0, 'Save')
    iter.set_value(1, 'document-save')

    treeview = Gtk::TreeView.new(@liststore)

    renderer_text = Gtk::CellRendererText.new
    column_text = Gtk::TreeViewColumn.new('Text', renderer_text, text: 0)
    treeview.append_column(column_text)

    renderer_pixbuf = Gtk::CellRendererPixbuf.new

    column_pixbuf = Gtk::TreeViewColumn.new("Image", renderer_pixbuf, icon_name: 1)
    treeview.append_column(column_pixbuf)
    add(treeview)
  end

end

if __FILE__ == $PROGRAM_NAME
  win = CellRendererPixbufWindow.new
  win.signal_connect(:destroy) { Gtk.main_quit }
  win.show_all
  win.move(0, 0)
  win.set_border_width(8)
  Gtk.main  
end