#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::SpinButtonExample
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/027_spin_button_example.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class SpinButtonExample < ::Gtk::Box # === Gtk::SpinButtonExample

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:vertical)
    main_vbox = ::Gtk::Box.new(:vertical)
    main_vbox.set_border_width(10)
    add(main_vbox)
    frame = ::Gtk::Frame.new('SpinButton example')
    main_vbox.pack_start(frame, expand: true, fill: true, padding: 0)

    vbox = ::Gtk::Box.new(:vertical)
    vbox.set_border_width(5)
    frame.add(vbox)

    # Day, month, year spinners 
    hbox = ::Gtk::Box.new(:horizontal)
    vbox.pack_start(hbox, expand: true, fill: true, padding: 5)

    vbox2 = ::Gtk::Box.new(:vertical)
    hbox.pack_start(vbox2, expand: true, fill: true, padding: 5)

    label = ::Gtk::Label.new('Day :')
    label.set_alignment(0, 0.5)
    vbox2.pack_start(label, expand: true, fill: true, padding: 0)
      
    adj = ::Gtk::Adjustment.new(1.0, 1.0, 31.0, 1.0, 5.0, 0.0)
    spinner = ::Gtk::SpinButton.new(adj, 0, 0)
    spinner.wrap = true
    # spinner.signal_connect(:event) {|widget, event|
    #   pp event.class
    # }
    vbox2.pack_start(spinner, expand: false, fill: true, padding: 5)

    vbox2 = ::Gtk::Box.new(:vertical)
    hbox.pack_start(vbox2, expand: true, fill: true, padding: 5)

    hbox = ::Gtk::Box.new(:horizontal)
    vbox.pack_start(hbox, expand: false, fill: true, padding: 5)
    button = ::Gtk::Button.new(label: 'Close')
    button.signal_connect(:clicked) { destroy } # Destroy the widget.
    hbox.pack_start(button, expand: true, fill: true, padding: 5)
  end

  # ========================================================================= #
  # === get_value
  # ========================================================================= #
  def get_value(spin, label, data)
    case data
    when 1
      buf = sprintf("%d", spin.value_as_int)
    else
      buf = sprintf("%0.*f", spin.digits, spin.value)
    end
    label.text = buf
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  window.move(0, 0)
  hbox = Gtk::Box.new(:horizontal)
  hbox.add(Gtk::SpinButtonExample.new)
  window.add(hbox)
  window.signal_connect(:delete_event) { Gtk.main_quit }
  window.show_all
  Gtk.main  
end