#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

Gtk::Settings.default.gtk_font_name = 'Sans 25'

USE_THESE_CSS_RULES = '

.tiny_button {
  background-image: none; 
  color:          blue;
  min-height:     2px;
  padding-bottom: 0px;
  padding-top:    0px;
  border: 5px dotted tomato;
}
'

# =========================================================================== #
# === enable_CSS_support
# =========================================================================== #
def enable_CSS_support
  provider = ::Gtk::CssProvider.new
  provider.load(data: USE_THESE_CSS_RULES)
  ::Gtk::StyleContext.add_provider_for_screen(
   Gdk::Screen.default,
    provider,
    Gtk::StyleProvider::PRIORITY_APPLICATION
  )
end

enable_CSS_support

window = Gtk::Window.new
box = Gtk::Box.new(:vertical)
text = Gtk::Label.new('This example shows how to style a tiny button in a button-box, via CSS.')
button = Gtk::Button.new(label: 'tiny')
button.signal_connect(:clicked) { puts 'The button was clicked.' }
button.style_context.add_class('tiny_button')
box.add(text)
button_box = ::Gtk::ButtonBox.new(:horizontal)
button_box.pack_start(button, fill: false, expand: false, padding: 0)
box.pack_start(button_box, fill: false, expand: false, padding: 0)
window.add(box)
window.show_all
window.move(0, 0)
window.set_border_width(25)
window.signal_connect(:destroy) { Gtk.main_quit }
Gtk.main