#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This example shows a password-entry.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/014_password_example.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class PasswordExample < ::Gtk::Box # === Gtk::PasswordExample

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:horizontal)
    set_border_width(20)
    run if run_already
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    password = ::Gtk::Entry.new
    password.set_visibility(false)
    password.invisible_char = 42 # This is '*' in Unicode.
    pack_start(password, fill: false, expand: false)
  end
  
end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  window.add(Gtk::PasswordExample.new)
  window.show_all
  window.set_size_request(500, -1)
  window.move(0, 0)
  window.signal_connect(:delete_event) { Gtk.main_quit }
  Gtk.main  
end