#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

window = Gtk::Window.new
vbox = Gtk::Box.new(:vertical)
@drawing_area = Gtk::DrawingArea.new
@drawing_area.set_size_request(200, 200)
@drawing_area.has_tooltip = true
@drawing_area.signal_connect(:draw) {
  # ========================================================================= #
  # We require the cairo-context:
  # ========================================================================= #
  cairo_context = @drawing_area.window.create_cairo_context
  # ========================================================================= #
  # Draw the rectangle next.
  # ========================================================================= #
  cairo_context.rectangle(
    5, 5, 80, 30
  )
  cairo_context.set_source_rgb(0.5, 0.9, 0.6)
  cairo_context.fill
  for i in (1..11) # Here we will modify the colour in use.
    cairo_context.set_source_rgba(0, 0, 1, i*0.1)
    cairo_context.rectangle(50*i, 50, 80, 80)
    cairo_context.fill
  end
}

vbox.pack_start(@drawing_area, expand: false, fill: false, padding: 50)
window.add(vbox)
window.set_size_request(700, 300)
window.move(0, 0)
window.show_all
window.signal_connect(:destroy) { Gtk.main_quit }
Gtk.main