#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::SpinnerExample
# =========================================================================== #
# require 'gtk_paradise/005_spinner_example.rb'
# =========================================================================== #
require 'gtk3'

module Gtk

class SpinnerExample < ::Gtk::Box # === Gtk::SpinnerExample

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:horizontal)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === title?
  # ========================================================================= #
  def title?
    'Spinner Example'
  end; alias title title? # === title

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @spinner
    # ======================================================================= #
    @spinner = ::Gtk::Spinner.new
    @spinner.set_active(false)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    show_all
    Thread.new {
      sleep 0.5 # Just to show how to activate it.
      @spinner.set_active(true)
    }
    add(@spinner)
    set_halign(:center)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  window.add(Gtk::SpinnerExample.new)
  window.move(0, 0)
  window.show_all
  window.set_size_request(500, 150)
  windows.signal_connect(:destroy) { Gtk.main_quit }
  Gtk.main
end