#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

alias e puts

dialog = Gtk::RecentChooserDialog.new(title: 'Recent Chooser Dialog Sample',
                                      buttons: [['_Cancel', :cancel],
                                                ['_Accept', :accept]])

dialog.move(0,0)
dialog.set_size_request(500, 400)
dialog.signal_connect(:response) { |_widget, response|
  case response
  when Gtk::ResponseType::ACCEPT
    info = dialog.current_item
    if info
      e "--------------------"
      e 'Chosen uri was:        '+info.uri
      e 'In a nicer display:    '+info.uri_display
      e 'The pure filename was: '+info.display_name
      e "--------------------"
      e info.description
      e info.mime_type
      e info.added
      e info.modified
      e info.visited
      e info.private_hint?
      p info.get_application_info('gedit')
      p info.applications
      e info.last_application
      p info.groups
      e info.has_group?("web")
      e info.has_application?('gedit')
      e info.get_icon(64)
      e info.age
      e info.local?
      e 'Does that file exist?: '+info.exist?.to_s
      e 'The short name is: '+info.short_name
      Gtk.main_quit
    end
  else
    e 'Close' # The close-button.
    dialog.destroy
    Gtk.main_quit
  end
}

dialog.show_all
Gtk.main