#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This simply shows ten gtk-label entries in a vertical box.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/ten_vboxes_example.rb
# =========================================================================== #
require 'gtk3'

::Gtk::Settings.default.gtk_font_name = 'Mono 22'

# =========================================================================== #
# === CSS_TO_USE
# =========================================================================== #
CSS_TO_USE = '
* {
  margin: 10px;
}'

css_provider = Gtk::CssProvider.new
css_provider.load(data: CSS_TO_USE)
Gtk::StyleContext.add_provider_for_screen(
  Gdk::Screen.default,
  css_provider,
  Gtk::StyleProvider::PRIORITY_APPLICATION
)
    
w = Gtk::Window.new

vbox = Gtk::Box.new(:vertical)
vbox.set_border_width(0)

vbox.add(Gtk::Box.new(:horizontal).add(Gtk::Label.new(' 1')))
vbox.add(Gtk::Box.new(:horizontal).add(Gtk::Label.new(' 2')))
vbox.add(Gtk::Box.new(:horizontal).add(Gtk::Label.new(' 3')))
vbox.add(Gtk::Box.new(:horizontal).add(Gtk::Label.new(' 4')))
vbox.add(Gtk::Box.new(:horizontal).add(Gtk::Label.new(' 5')))
vbox.add(Gtk::Box.new(:horizontal).add(Gtk::Label.new(' 6')))
vbox.add(Gtk::Box.new(:horizontal).add(Gtk::Label.new(' 7')))
vbox.add(Gtk::Box.new(:horizontal).add(Gtk::Label.new(' 8')))
vbox.add(Gtk::Box.new(:horizontal).add(Gtk::Label.new(' 9')))
vbox.add(Gtk::Box.new(:horizontal).add(Gtk::Label.new('10')))
vbox.show_all
w.add(vbox)
w.show_all
w.set_size_request(540, 280)
w.move(0, 0)
w.signal_connect(:delete_event) { Gtk.main_quit }
Gtk.main