#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This is just a simple gtk-label example for ruby-gtk3.
# =========================================================================== #
require 'gtk3'

::Gtk::Settings.default.gtk_font_name = 'Hack 20'

heredoc = <<-EOF
Hello world!

This is an example for a more complicated Gtk::Label.

You can use markup, thus colours, by making use of:

    .set_text()

and

    .use_markup = true

Some <a href="http://en.wikipedia.org/wiki/Text" title="plain text">text</a> 
may be marked up as hyperlinks, which can be clicked
or activated via <a href="keynav">keynav</a>
and they work fine with other markup, like when
searching on <a href="http://www.google.com/">
  <span color="#0266C8">G</span><span color="#F90101">o</span>
  <span color="#F2B50F">o</span><span color="#0266C8">g</span>
  <span color="#00933B">l</span><span color="#F90101">e</span>
  </a>
EOF


w = Gtk::Window.new

hbox = Gtk::Box.new(:vertical)

label1 = Gtk::Label.new
label1.set_text(heredoc)
label1.use_markup = true
hbox.add(label1)

label2 = Gtk::Label.new(
  ' This is the second label - it is shifted',
  use_underline: true
)
label2.angle = 5
hbox.add(label2)

label3 = Gtk::Label.new('And this is aligned to the right hand side.')
label3.set_alignment(1, 1)
hbox.add(label3)

content = <<-EOF
This is an example of a line-wrapped label.
should not be taking up the entire

width allocated to it, but automatically 
wraps the words to fit.\n

It supports multiple paragraphs correctly, 
and correctly
adds 
many
extra spaces.   

EOF
label4 = Gtk::Label.new(content)
label4.set_line_wrap(true)
label4.set_max_width_chars(32)
hbox.add(label4)

hbox.show_all

scrolled_window = Gtk::ScrolledWindow.new
scrolled_window.add_with_viewport(hbox)
scrolled_window.set_policy(:automatic, :always)

w.add(scrolled_window)
w.show_all
w.set_size_request(1080, 880)
w.move(0, 0)
w.set_border_width(12)
w.signal_connect(:delete_event) { Gtk.main_quit }
Gtk.main