#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This is an example for frames containing elements that can be reparented.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/058_frame_example.rb
# =========================================================================== #
require 'gtk3'

# =========================================================================== #
# === SWITCH_TEXT
# =========================================================================== #
SWITCH_TEXT = 'switch here to (will use .reparent)'

# =========================================================================== #
# Use a specific font size next:
# =========================================================================== #
::Gtk::Settings.default.gtk_font_name = 'Mono 22'

window = Gtk::Window.new('buttons')
window.signal_connect(:destroy) { Gtk.main_quit }
window.border_width = 0

box1 = Gtk::Box.new(:vertical, 0)

box2 = Gtk::Box.new(:horizontal, 5)
box2.border_width = 10
box1.pack_start(box2, expand: true, fill: true, padding: 0)

label = Gtk::Label.new('Hello World')
frame1 = Gtk::Frame.new('Frame 1')
box2.pack_start(frame1, expand: true, fill: true, padding: 0)

box3 = Gtk::Box.new(:vertical, 5)
box3.border_width = 5
frame1.add(box3)

button = Gtk::Button.new(label: SWITCH_TEXT)
button.signal_connect(:clicked) { label.reparent(box3) } # Do reparenting here.
box3.pack_start(button, expand: true, fill: true, padding: 0)
box3.pack_start(label,  expand: true, fill: true, padding: 0)

frame2 = Gtk::Frame.new('Frame 2')
frame2.label_widget.set_selectable(true)
box2.pack_start(frame2, expand: true, fill: true, padding: 0)

box4 = Gtk::Box.new(:vertical, 5)
box4.border_width = 5
frame2.add(box4)

button = Gtk::Button.new(label: SWITCH_TEXT)
button.signal_connect(:clicked) { label.reparent(box4) } # Do reparenting here.
box4.pack_start(button, expand: true, fill: true, padding: 0)

separator = Gtk::Separator.new(:horizontal)
box1.pack_start(separator, expand: true, fill: true, padding: 0)

box2 = Gtk::Box.new(:horizontal, 10)
box2.border_width = 10
box1.pack_start(box2, expand: true, fill: true, padding: 0)

# =========================================================================== #
# Add the clost-button next.
# =========================================================================== #
button_close = Gtk::Button.new(label: 'close')
button_close.signal_connect(:clicked) { Gtk.main_quit }
box2.pack_start(button_close)
box2.pack_start(Gtk::Label.new('Also showing some button styles'))

box3 = Gtk::Box.new(:vertical)
frame1 = Gtk::Frame.new
frame1.shadow_type = Gtk::ShadowType::IN
label1 = Gtk::Label.new('Frame 1: Shadow type in')
frame1.add(label1)
box3.pack_start(frame1)

frame2 = Gtk::Frame.new
frame2.shadow_type = Gtk::ShadowType::OUT
label2 = Gtk::Label.new('Frame 2: Shadow type out')
frame2.add(label2)
box3.pack_start(frame2)

frame3 = Gtk::Frame.new
frame3.shadow_type = Gtk::ShadowType::ETCHED_IN

label3 = Gtk::Label.new('Frame 3: Shadow etched in')
frame3.add(label3)
box3.pack_start(frame3)

frame4 = Gtk::Frame.new
frame4.shadow_type = Gtk::ShadowType::ETCHED_OUT
label4 = Gtk::Label.new('Frame 4: Shadow etched out')
frame4.add(label4)
box3.pack_start(frame4)

mixed_box = Gtk::Box.new(:vertical)
mixed_box.add(box1)
mixed_box.add(box3)
window.add(mixed_box)
window.show_all
window.set_size_request(800, 150)
window.move(0, 0)
Gtk.main