#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/examples/gtk3/header_bar_example.rb'
# =========================================================================== #
require 'gtk3'

alias e puts

window = Gtk::Window.new
window.set_border_width(12)
window.set_size_request(520, 420)
window.signal_connect(:destroy) { Gtk.main_quit } 

box = Gtk::Box.new(:vertical)
# =========================================================================== #
# Create the header-bar next:
# =========================================================================== #
header_bar = Gtk::HeaderBar.new
header_bar.show_close_button = true 
header_bar.title = 'HeaderBar example'
header_bar.subtitle = 'And this is the subtitle to use'
header_bar.spacing = 22

# =========================================================================== #
# Next add three buttons.
# =========================================================================== #
button = Gtk::Button.new
icon = Gio::ThemedIcon.new('mail-send-receive-symbolic') 
image = Gtk::Image.new(icon: icon, size: :button)
button.set_image(image)
header_bar.pack_end(button)

button = Gtk::Button.new
icon = Gio::ThemedIcon.new('mail-send-receive')
image = Gtk::Image.new(icon: icon, size: :button)
button.set_image(image)
header_bar.pack_end(button)

button = Gtk::Button.new
icon = Gio::ThemedIcon.new('pan-end-symbolic')
image = Gtk::Image.new(icon: icon, size: ::Gtk::IconSize::MENU)
button.set_image(image)
header_bar.pack_end(button)

button = Gtk::Button.new
button.signal_connect(:clicked) { e 'This may be used for a document-open action.' }
_ = ::Gtk::IconTheme.default.load_icon('document-open', 32, 0)
result = ::Gtk::Image.new(pixbuf: _)
button.add(result)

header_bar.add(button)

header_bar.set_size_request(820, 60)
box.add(header_bar)
box.pack_start(Gtk::TextView.new, expand: true, fill: true)
window << box
window.show_all
window.move(0, 0)
Gtk.main