#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === TextViewExample
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/006_text_view_example.rb
# =========================================================================== #
require 'gtk3'

class TextViewExample < ::Gtk::Box

  alias e puts

  # ========================================================================= #
  # === FILE
  #
  # FILE = '/test_file.md'
  # FILE = '/Depot/j/foo.md'
  # ========================================================================= #
  FILE = '/yo.yml'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:vertical)
    run if run_already
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    text_buffer = Gtk::TextBuffer.new
    text_buffer.set_text(
      "Hello world!\n"*100
    )
    # ======================================================================= #
    # The next line is for debugging-purposes on my home setup.
    # ======================================================================= #
    if File.exist? FILE
      text_buffer.set_text(File.read(FILE))
    end
    text_view = Gtk::TextView.new(text_buffer)
    text_view.set_size_request(1200, 800)
    scrolled_window = Gtk::ScrolledWindow.new
    scrolled_window.add_with_viewport(text_view)
    scrolled_window.show_all
    scrolled_window.set_size_request(800, 600)
    box = Gtk::Box.new(:vertical)
    box.add(
      Gtk::Label.new('Showing a TextView widget next:')
    )
    box.pack_start(
      scrolled_window, fill: true, expand: true, padding: 8
    )
    box.add(
      Gtk::Separator.new(:horizontal)
    )
    box.show_all
    add(box)
    show_all
  end

end

window = Gtk::Window.new
window.move(0, 0)
window.show_all
window.add(TextViewExample.new)
this_font = 'Sans 22'
_ = Pango::FontDescription.new(this_font)
window.override_font(_)
window.set_size_request(1400, 760)
window.signal_connect(:destroy) { Gtk.main_quit }
Gtk.main