#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This example show a gtk-check-button.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/044_check_button.rb
# =========================================================================== #
require 'gtk3'

alias e puts

window = Gtk::Window.new
window.set_title('GTK CheckButton example')
vbox = Gtk::Box.new(:vertical)

check_button = Gtk::CheckButton.new('This is an _example for a check button')
check_button.use_underline = true # Specifically enable support for underlined accelerators.
check_button.active = true
check_button.set_border_width(40)
check_button.signal_connect(:toggled) { e 'This widget was toggled.' }

vbox.add(check_button)
window.add(vbox)
window.show_all
window.move(0, 0)
window.set_border_width(5)
window.signal_connect(:delete_event) { Gtk.main_quit }
Gtk.main