#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This example collects a lot of markup-related effects together into a
# single .rb file.
# =========================================================================== #
require 'gtk3'

alias e puts

MARKUP_TEXT_TO_USE = '

Text sizes: <span size="xx-small">tiny</span> <span size="x-small">very small</span> <span size="small">small</span> <span size="medium">normal</span> <span size="large">large</span> <span size="x-large">very large</span> <span size="xx-large">huge</span>

Text <span color="gray">c<span color="green">o</span>l<span color="tomato">o</span>rs</span> and <span background="pink">backgrounds</span>

Colorful <span underline="low" underline-color="blue"><span underline="double" underline-color="red">under</span>lines</span> and <span background="pink"><span underline="error">mo</span><span underline="error" underline-color="green">re</span></span>

Colorful <span strikethrough="true" strikethrough-color="magenta">strikethroughs</span>

Superscripts and subscripts: 𝜀<span rise="-6000" size="x-small" font_desc="italic">0</span> = 𝜔<span rise="8000" size="smaller">𝜔<span rise="14000" size="smaller">𝜔<span rise="20000">.<span rise="23000">.<span rise="26000">.</span></span></span></span></span>

<span letter_spacing="3000">Letterspacing</span>

OpenType font features: <span font_desc="sans regular" font_features="dlig=0">feast</span> versus <span font_desc="sans regular" font_features="dlig=1">feast</span>

Shortcuts: <tt>Monospace</tt> – <b>Bold</b> – <i>Italic</i> – <big>Big</big> – 
<small>Small</small> – <u>Underlined</u> – <s>Strikethrough</s> – Super<sup>script</sup> – Sub<sub>script</sub>
'
splitted = MARKUP_TEXT_TO_USE.split("\n").reject {|line| line.strip.empty? }

::Gtk::Settings.default.gtk_font_name = 'Mono 22'

box = Gtk::Box.new(:vertical)
window = Gtk::Window.new

splitted.each {|entry|
  gtk_label = Gtk::Label.new(entry)
  gtk_label.set_markup(entry)
  box.add(gtk_label)
}
window.show_all
window.add(box)
window.show_all
window.set_size_request(1500, 800)
window.move(50, 50)
window.signal_connect(:delete_event) { Gtk.main_quit }
window.title = 'This example shows how to use markup code in text (gtk-label)'
Gtk.main