require 'gtk3'

def on_destroy(widget)
  Gtk.main_quit
  return false
end

def scroll_notify_event(w, event)
  if event.direction == Gdk::ScrollDirection::UP
    puts 'You scrolled up.'
  elsif event.direction == Gdk::ScrollDirection::DOWN
    puts 'You scrolled down.'
  end
end

window = Gtk::Window.new
window.signal_connect(:destroy) { |widget| on_destroy(widget) }
eventbox = Gtk::EventBox.new
window.signal_connect(:scroll_event) { |widget, event| scroll_notify_event(widget, event) }
hbox = Gtk::Box.new(:vertical)
hbox.add(eventbox)

def msg_scroll_up
  pp caller()
  puts 'BEGIN-------'
  puts '  You scrolled up.'
  puts 'END---------'
end

def msg_scroll_down
  pp caller()
  puts 'BEGIN-------'
  puts '  You scrolled down.'
  puts 'END---------'
end

entry = Gtk::Entry.new
entry.add_events(:scroll_mask)
entry.signal_connect(:event) {|widget, event|
  case event.class.to_s
  when 'Gdk::EventScroll'
    direction = event.direction
    puts 'Scrolling in the entry.'
    if direction == Gdk::ScrollDirection::UP
      msg_scroll_up
    elsif direction == Gdk::ScrollDirection::DOWN
      msg_scroll_down
    end
  end
}

hbox.add(entry)
window.add(hbox)
window.set_size_request(500, 150)
window.show_all
Gtk.main