#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colourized_button_example.rb'
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/042_colourized_button_example.rb
# =========================================================================== #
require 'gtk3'

alias e puts

window = Gtk::Window.new
window.set_size_request(400, 400)

# Create our button.
button = Gtk::Button.new(label: 'Button - with CSS')
button.signal_connect(:clicked) {
  e 'We clicked on the button!'
}

button.signal_connect(:event) {|widget, event|
  if event.button == 1
    puts 'links' # linker knopf
  elsif event.button == 2
    puts 'mitte' # mausknopf in der mitte
  elsif event.button == 3
    puts 'rechts' # right/rechter maus button
  end
}

button.margin = 50
button.set_size_request(100, -1)

font = Pango::FontDescription.new('35')
button.override_font(font)

yellow  = Gdk::RGBA.new(1.0, 1.0,   0, 1.0)
cyan    = Gdk::RGBA.new(  0, 1.0, 1.0, 1.0)
green   = Gdk::RGBA.new(  0, 1.0,   0, 1.0)
magenta = Gdk::RGBA.new(1.0,   0, 1.0, 1.0)
white   = Gdk::RGBA.new(1.0, 1.0, 1.0, 1.0)
blue    = Gdk::RGBA.new(  0,   0, 1.0, 1.0)

# =========================================================================== #
# background color of the button; only color flashes
# =========================================================================== #
button.override_background_color(:normal  , yellow)
button.override_background_color(:prelight,   cyan)
button.override_background_color(:active  ,  green)

# label color of the button
button.override_color(:normal  , magenta)
button.override_color(:prelight,    blue)
button.override_color(:active  ,   white) # not active

css_provider = Gtk::CssProvider.new
# =========================================================================== #
# Start CSS description:
# =========================================================================== #
css_provider.load(data: <<-CSS)
button {
  background-image: image(cyan);
}

button:hover {
  background-image: image(green);
}

button:active {
  background-image: image(brown);
}
CSS

fixed = Gtk::Fixed.new
fixed.put(button, 25, 25)
window.add(fixed)
window.show_all
window.signal_connect(:destroy) { Gtk.main_quit }
window.move(0, 0)
Gtk.main