#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/menubar_example.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class MenubarExample < Gtk::Window

  alias e puts

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super()
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    set_title 'Simple menubar'
    Gtk::Settings.default.gtk_font_name = 'DejaVu Sans Mono 20'
  end

  # ========================================================================= #
  # === add_main_box
  # ========================================================================= #
  def add_main_box
    vbox = Gtk::Box.new(:vertical, 2)
    vbox.pack_start(
      @menu_bar, expand: false, fill: false, padding: 0
    )
    add(vbox)
  end

  # ========================================================================= #
  # === create_user_interface
  # ========================================================================= #  
  def create_user_interface
    override_background_color(
      :normal, 
      Gdk::RGBA.new(0.999, 0.999, 0.999, 1)
    )
    # ======================================================================= #
    # Create the menu-bar next.
    # ======================================================================= #
    @menu_bar = Gtk::MenuBar.new
    filemenu = Gtk::Menu.new
    filem = Gtk::MenuItem.new(label: 'File')
    filem.set_submenu(filemenu)

    button_hello_world = Gtk::MenuItem.new(label: 'Hello world')
    button_hello_world.signal_connect(:activate) { e 'Hello world' }
    filemenu.append(button_hello_world)

    exit = Gtk::MenuItem.new(label: 'Exit')
    exit.signal_connect(:activate) { Gtk.main_quit }
    filemenu.append(exit)

    @menu_bar.append(filem)
    connect_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    add_main_box
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    create_user_interface
    signal_connect(:destroy) { Gtk.main_quit }
    set_default_size(400, 300)
    set_window_position :center
    show_all
    Gtk.main
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::MenubarExample.new
end