#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::RadioButtonWindow
# =========================================================================== #
# This code shows an example how to work with radio-buttons in gtk3.
# =========================================================================== #
# require 'gtk_paradise/examples/gtk3/020_radio_button_window.rb'
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/020_radio_button_window.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class RadioButtonWindow < Gtk::Box # === Gtk::RadioButtonWindow

  alias e puts

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'RadioButton Demo'

  # ========================================================================= #
  # === VERTICAL_OR_HORIZONTAL
  # ========================================================================= #
  VERTICAL_OR_HORIZONTAL = :vertical

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(VERTICAL_OR_HORIZONTAL, 6)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    set_title(TITLE) if respond_to? :set_title
    set_border_width(15)
  end

  # ========================================================================= #
  # === on_button_toggled
  # ========================================================================= #
  def on_button_toggled(button, name)
    active_or_not_active = button.active? ? 'on' : 'off'
    e "Button #{name} was turned #{active_or_not_active} - "\
      "its text is: #{button.label}"
  end

  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
    @button1 = ::Gtk::RadioButton.new(label: '_Austria', use_underline: true)
    @button1.signal_connect(:toggled) { |b| on_button_toggled(b, 1) }

    @button2 = ::Gtk::RadioButton.new(member: @button1, label: '_Germany', use_underline: true)
    @button2.signal_connect(:toggled) { |b| on_button_toggled(b, 2) }

    @button3 = ::Gtk::RadioButton.new(member: @button1, label: 'Fr_ance', use_underline: true)
    @button3.signal_connect(:toggled) { |b| on_button_toggled(b, 3) }
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    pack_start(@button1)
    pack_start(@button2)
    pack_start(@button3)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    create_skeleton
    connect_skeleton
  end

end; end

if __FILE__ == $PROGRAM_NAME
  radio_button_window = Gtk::RadioButtonWindow.new
  window = Gtk::Window.new
  window.add(radio_button_window)
  window.signal_connect(:destroy) { Gtk.main_quit }
  window.set_size_request(500, 120)
  window.show_all
  window.move(0, 0)
  Gtk.main
end