#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

alias e puts

e 'Enter "G", "t" on the entry box, a dropdown will appear.'

# =========================================================================== #
# === ARRAY_COMPLETE_TO_THESE_ENTRIES
# =========================================================================== #
ARRAY_COMPLETE_TO_THESE_ENTRIES = %w( GNOME GNAME total totally tota )

window = Gtk::Window.new
window.set_default_size(300, 00)
window.move(0, 0)
entry = Gtk::Entry.new
completion = Gtk::EntryCompletion.new
completion.signal_connect(:match_selected) {|widget, event|
  e 'A match was selected. The text so far is: '+
    entry.text.to_s
  Thread.new {
    sleep 2 # This just demonstrates that you can use a delay to get the true value.
    e entry.text.to_s
  }
  false
}

entry.completion = completion

model = Gtk::ListStore.new(String)

ARRAY_COMPLETE_TO_THESE_ENTRIES.each { |v|
  iter = model.append
  iter[0] = v
}

completion.model = model
completion.text_column = 0
window.signal_connect(:delete_event) { Gtk.main_quit }
window.set_border_width(25)

window.add(entry).show_all.signal_connect(:destroy) { Gtk.main_quit }
Gtk.main