#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::SmallPanedExample
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/004_small_paned_example.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class SmallPanedExample < ::Gtk::Paned # === Gtk::SmallPanedExample

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:horizontal)
    run if run_already
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    button1 = ::Gtk::Button.new(label: 'Resize →')
    button2 = ::Gtk::Button.new(label: '← here')
    button1.signal_connect(:clicked) { puts 'button1 was clicked' }
    button2.signal_connect(:clicked) { puts 'button2 was clicked' }
    pack1(button1)
    pack2(button2)
    show_all
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  paned = ::Gtk::SmallPanedExample.new
  paned.set_border_width(25)
  window.add(paned)
  window.set_size_request(255, 150)
  window.show_all
  window.move(0, 0)
  window.signal_connect(:destroy){ Gtk.main_quit }
  Gtk.main
end