#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ScaleButtonDemo
# =========================================================================== #
# This example will show a typical "scale-button" in gtk3.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/021_scale_button_demo.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class ScaleButtonDemo < ::Gtk::Box

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:vertical)
    scale = ::Gtk::ScaleButton.new
    scale.set_value(50)
    # scale.set_valign(0.5) # :end)
    # scale.set_halign(0.5) # :end)
    add(scale)
    self.vexpand = true
    self.hexpand = true
    scale.set_icons(
      %w( go-bottom go-top system-run )
    )
    scale.signal_connect(:value_changed) { |_widget, value|
      puts "value changed: #{value}"
    }
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  window.set_size_request(300, 300)
  window.move(0, 0)
  window.add(
    Gtk::ScaleButtonDemo.new
  )
  # see here for an explication  on icons order
  #   https://developer.gnome.org/gtk3/stable/GtkScaleButton.html#GtkScaleButton--icons
  window.show_all
  window.signal_connect(:destroy) { Gtk.main_quit }
  Gtk.main
end