#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/simple_window.rb
# =========================================================================== #
require 'gtk3'

alias e puts

# =========================================================================== #
# === TRY_TO_PLAY_VIDEO_FILE
# =========================================================================== #
TRY_TO_PLAY_VIDEO_FILE = false

window = Gtk::Window.new
window.set_size_request(800, 600)
window.realize
# =========================================================================== #
# Next query for its xid value.
# =========================================================================== #
xid_value = window.window.xid.to_s
e 'The windows xid is: '+xid_value
if TRY_TO_PLAY_VIDEO_FILE
  _ = 'mpv --wid='+xid_value+' --start=280 /home/x/video/Realvids/224_Tremors.mp4'
  e _
  system _
end

box = Gtk::Box.new(:vertical)
button = Gtk::Button.new(label: 'Run mplayer')

button.signal_connect(:clicked) {|widget, event|
  # ========================================================================= #
  # Let mpv play via the specified XID value.
  # ========================================================================= #
  Thread.new {
    _ = 'mpv --wid='+xid_value+' --start=280 /home/x/video/Realvids/224_Tremors.mp4'
    e _
    system _
  }
} 
box.add(button)
window.add(box)
window.show_all
# =========================================================================== #
# Next we use several calls to .set_title(). The reason this was added
# was mostly to find out whether a newly set title overrides an older
# title. This is indeed the case.
# =========================================================================== #
window.set_title('A - 002_simple_window.rb')
window.set_title('B - 002_simple_window.rb')
window.set_title('C - 002_simple_window.rb')
window.set_title('This is a test')
window.move(0, 0)
window.signal_connect(:destroy) { Gtk.main_quit }
Gtk.main