#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::HoverButtonExampleViaCss
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/026_hover_button_example_via_css.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class HoverButtonExampleViaCss < ::Gtk::Box # === Gtk::HoverButtonExampleViaCss

  alias e puts

  # ========================================================================= #
  # === USE_THIS_AS_THE_CSS_STRING
  # ========================================================================= #
  USE_THIS_AS_THE_CSS_STRING = <<-EOF

button {
  font-size: 36px;
  background-image: none;
  background-color: yellow;
}

button:hover {
  transition: 4000ms linear;
  background-color: lightblue;
}

#bblack1 { border: 1px solid black; }

EOF

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:vertical)
    enable_CSS_support
    set_border_width(25)
    button = ::Gtk::Button.new(
      label: "Test hover action and transition -\n"\
             "place the mouse cursor over this text.\n"\
             "This functionality is implemented via button:hover, and transition:"
    )
    button.set_name('bblack1')
    button.signal_connect(:clicked) { e 'Click me!' }
    add(button)
    add(::Gtk::Separator.new(:horizontal))
  end

  # ========================================================================= #
  # === enable_CSS_support
  # ========================================================================= #
  def enable_CSS_support
    provider = ::Gtk::CssProvider.new
    provider.load(data: USE_THIS_AS_THE_CSS_STRING)
    ::Gtk::StyleContext.add_provider_for_screen(
      Gdk::Screen.default,
      provider,
      Gtk::StyleProvider::PRIORITY_APPLICATION
    )
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  window.add(Gtk::HoverButtonExampleViaCss.new)
  window.show_all
  window.set_size_request(880, 600)
  window.move(0, 0)
  window.signal_connect(:destroy) { Gtk.main_quit }
  Gtk.main  
end