#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

alias e puts

dialog = Gtk::FileChooserDialog.new(
  title: 'Gtk::FileChooser sample',
  action: :open,
  buttons: [[Gtk::Stock::OPEN,   :accept],
            [Gtk::Stock::CANCEL, :cancel]]
)

extra_button = Gtk::Button.new(label: 'Extra button')
extra_button.signal_connect(:clicked) {
  e 'extra button is clicked'
}

dialog.extra_widget = extra_button

# =========================================================================== #
# === Gtk::FileFilter
# =========================================================================== #
filter_rb = Gtk::FileFilter.new
filter_rb.name = 'Ruby Scripts'
filter_rb.add_pattern('*.rb')
filter_rb.add_pattern('*.rbw')
dialog.add_filter(filter_rb)

filter_c = Gtk::FileFilter.new
filter_c.name = 'C sources'
filter_c.add_pattern('*.[c|h]')
dialog.add_filter(filter_c)

dialog.add_shortcut_folder('/tmp')
dialog.add_shortcut_folder('/home/Temp') if File.directory?('/home/Temp')

case dialog.run
when Gtk::ResponseType::ACCEPT
  e "filename = #{dialog.filename}"
  e "uri = #{dialog.uri}"
end