#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::IconThemeExample
# =========================================================================== #
# This example only works on ruby-gtk3, not ruby-gtk2.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/013_icon_theme_example.rb
# =========================================================================== #
require 'gtk3'

# =========================================================================== #
# === Use a horizontal box next
# =========================================================================== #
module Gtk

class IconThemeExample < ::Gtk::Box

  # ========================================================================= #
  # === DEFAULT_ICON_SIZE
  # ========================================================================= #
  DEFAULT_ICON_SIZE = 32

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:horizontal)
    icon_theme = ::Gtk::IconTheme.default

    use_this_icon_name = 'folder-music'
    icon1 = icon_theme.load_icon(use_this_icon_name, DEFAULT_ICON_SIZE, 0)
    image1 = new_pixbuf_image(icon1) # Use the icon here.
    pack_start(image1, padding: 2)

    use_this_icon_name = 'dialog-password'
    icon2 = icon_theme.load_icon(use_this_icon_name, DEFAULT_ICON_SIZE, 0)
    image2 = new_pixbuf_image(icon2) # Use the icon here.
    pack_start(image2, padding: 2)

    use_this_icon_name = 'window-close'
    icon3 = icon_theme.load_icon(use_this_icon_name, DEFAULT_ICON_SIZE, 0) # Use the window-close example.
    image3 = new_pixbuf_image(icon3) # Use the icon here.
    pack_start(image3, padding: 2)

    use_this_icon_name = 'folder-download'
    icon4 = icon_theme.load_icon(use_this_icon_name, DEFAULT_ICON_SIZE, 0)
    image4 = new_pixbuf_image(icon4) # Use the icon here.
    pack_start(image4, padding: 2)

    begin # This icon is not always available.
      use_this_icon_name = 'audio-speakers'
      icon5 = icon_theme.load_icon(use_this_icon_name, DEFAULT_ICON_SIZE, 0)
      image5 = new_pixbuf_image(icon5) # Use the icon here.
      pack_start(image5, padding: 2)
    rescue Exception => error
      pp error
    end

    use_this_icon_name = 'emblem-readonly'
    icon6 = icon_theme.load_icon(use_this_icon_name, DEFAULT_ICON_SIZE, 0)
    image6 = new_pixbuf_image(icon6) # Use the icon here.
    pack_start(image6, padding: 2)

    use_this_icon_name = 'emblem-shared'
    icon7 = icon_theme.load_icon(use_this_icon_name, DEFAULT_ICON_SIZE, 0)
    image7 = new_pixbuf_image(icon7) # Use the icon here.
    pack_start(image7, padding: 2)

    use_this_icon_name = 'network-wired-symbolic.symbolic'
    icon8 = icon_theme.load_icon(use_this_icon_name, DEFAULT_ICON_SIZE, 0)
    image8 = new_pixbuf_image(icon8)
    image8.icon_size = 125
    pack_start(image8, padding: 2)

    use_this_icon_name = 'preferences-system-search-symbolic.symbolic'
    icon9 = icon_theme.load_icon(use_this_icon_name, DEFAULT_ICON_SIZE*2, 0)
    image9 = new_pixbuf_image(icon9)
    pack_start(image9, padding: 2)

    use_this_icon_name = 'open-menu-symbolic'
    icon10 = icon_theme.load_icon(use_this_icon_name, DEFAULT_ICON_SIZE*2, 0)
    image10 = new_pixbuf_image(icon10)
    pack_start(image10, padding: 2)

    reset
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    set_border_width(12)
  end

  # ========================================================================= #
  # === new_pixbuf_image
  # ========================================================================= #
  def new_pixbuf_image(icon)
    ::Gtk::Image.new(pixbuf: icon)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  window.add(Gtk::IconThemeExample.new)
  window.show_all
  window.set_size_request(600, -1)
  window.move(0, 0)
  window.signal_connect(:delete_event) { Gtk.main_quit }
  Gtk.main  
end