# =========================================================================== #
# Adapted from:
#
#   https://github.com/ruby-gnome/ruby-gnome/blob/master/gtk3/sample/misc/colorchooser.rb
#
# Thus this file uses the very same licence as rubygnome and
# that .rb file here.
# =========================================================================== #
require 'gtk3'

class ColourChooserExample

  alias e puts

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    reset
    # ======================================================================= #
    # Create a new color-chooser widget.
    # ======================================================================= #
    @color_selection = Gtk::ColorChooserWidget.new
    @color_selection.tooltip_text = 'Choose a colour here.'
    @color_selection.use_alpha = true
    # ======================================================================= #
    # pp @color_selection.methods.sort
pp ::Gtk::ColorChooserWidget.methods.sort
    # ======================================================================= #
    # @color_selection.signal_connect(:event) { |widget, event|
    #   pp event.class
    # }
    # ======================================================================= #
    @color_selection.signal_connect(:color_activated) { |widget, this_colour_was_chosen|
      @selected_colour = this_colour_was_chosen # Keep track of the colour that was chosen here.
      e 'The chosen colour was: '+
        this_colour_was_chosen.to_s
      e
      e '  Red:   '+this_colour_was_chosen.red.to_s
      e '  Green: '+this_colour_was_chosen.green.to_s
      e '  Blue:  '+this_colour_was_chosen.blue.to_s
      e
      Gtk.main_quit
    }
    window = Gtk::Window.new
    window.border_width = 18
    button = Gtk::Button.new(label: 'Quit')
    box = Gtk::Box.new(:vertical)
    box.add(@color_selection)
    box.add(button)
    window.add(box)
    window.show_all
    window.signal_connect(:destroy) { Gtk.main_quit }
    button.signal_connect(:clicked) {
      Gtk.main_quit
    }
    Gtk.main
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    @selected_colour = nil
  end

end

if __FILE__ == $PROGRAM_NAME
  ColourChooserExample.new  
end