#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# '004_simple_dialog_example.rb'
# =========================================================================== #
if ENV['IS_ROEBE'].to_i == 1
  begin
    require 'gtk_paradise/require_gtk3' # This is for my home setup.
  rescue LoadError
    require 'gtk3'
  end
else # regular users use this variant by default instead.
  require 'gtk3'
end

alias e puts

dialog = Gtk::Dialog.new
dialog.add_button(Gtk::Stock::YES, :yes)
dialog.add_button(Gtk::Stock::NO,  :no)
dialog.set_size_request(400, 200)
label = Gtk::Label.new('Do you like GTK?')
label.show
dialog.child.pack_start(label)

if ENV['IS_ROEBE'].to_i == 1
  # We add an ImageViewer on my home setup. Other users can
  # ignore this just fine.
  begin
    require 'gtk_paradise/widgets/gtk3/image_viewer/image_viewer.rb'
    image_viewer = Gtk::ImageViewer.new
    image_viewer.show_all
    image_viewer.set_work_on_this_directory(
      '/home/x/data/images/games/magic_the_gathering/the_dark/'
    )
    image_viewer.do_populate_with_all_discovered_images
    dialog.child.pack_end(image_viewer)
    dialog.child.show_all
  rescue LoadError; end
end
response = dialog.run
dialog.destroy

case response
when Gtk::ResponseType::YES
  e 'The user selected yes.'
when Gtk::ResponseType::NO
  e 'The user selected no.'
else
  e 'The user selected something else.'
end