#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

# =========================================================================== #
# === TOOLTIP_TEXT
# =========================================================================== #
TOOLTIP_TEXT = 'This text will show up upon a hover-event.'

status_icon       = Gtk::StatusIcon.new
status_icon.stock = Gtk::Stock::DIALOG_INFO
status_icon.set_icon_name('default_status_icon_name') # We can set a name.
status_icon.set_tooltip_text(TOOLTIP_TEXT)
status_icon.signal_connect(:activate) { |icon|
  icon.blinking = !(icon.blinking?)
}

# =========================================================================== #
# Add a menu and a quit-button too. These will be triggered upon a
# right-mouse-button presse vent.
# =========================================================================== #
menu = Gtk::Menu.new
quit = Gtk::ImageMenuItem.new(stock: Gtk::Stock::QUIT)
quit.signal_connect(:activate) { Gtk.main_quit }
menu.append(quit)
menu.show_all

status_icon.signal_connect(:popup_menu) { |icon, button, time|
  menu.popup(nil, nil, button, time)
}

# =========================================================================== #
#
# Note that an alternative to the above would be:
#
#   status_icon.signal_connect(:popup_menu) { |button, activate_time|
#     on_right_click(button, activate_time)
#   }
#
#   def on_right_click(status_icon, button, activate_time)
#     rc_menu = Gtk::Menu.new
#     exit = Gtk::ImageMenuItem.new('Quit')
#     exit_image = Gtk::Image.new(Gtk::Stock::QUIT, Gtk::IconSize::MENU)
#     exit.set_image(exit_image)
#     exit.signal_connect('activate') { Gtk.main_quit }
#     rc_menu.append(exit)
#     rc_menu.show_all
#     rc_menu.popup(nil, nil, button, activate_time)
#   end
#   trayicon.signal_connect(:popup_menu, &method(:on_right_click))
# =========================================================================== #
Gtk.main