#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This example shows how to work with two windows at the same time, and
# use a button that closes only one of these two windows. It was added
# because I needed a way to handle the creation (and closing) of multiple
# windows, without depending on the default gtk-widgets, such as the
# MessageDialog variants, whose API I really dislike.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/007_two_windows_example.rb
# =========================================================================== #
require 'gtk3'

alias e puts

w1 = Gtk::Window.new
w2 = Gtk::Window.new

w1.add(Gtk::Label.new('OK'))
w1.set_size_request(800,800)
w1.show_all

button = Gtk::Button.new(label: 'Destroy')
button.signal_connect(:clicked) {
  w2.destroy
}
w2.add(button)
w2.set_size_request(800,800)
w2.show_all

Gtk.main