#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/svg_viewer.rb
# =========================================================================== #
require 'gtk3'
require 'rsvg2'

alias e puts

if ARGV.empty?
  e "usage: #{$0} input.svg"
  exit(-1)
end

input = ARGV.shift

handle = Rsvg::Handle.new(path: input)
width, height = handle.dimensions.to_a

window = Gtk::Window.new
window.set_default_size(width, height)
window.signal_connect(:destroy) { Gtk.main_quit }

# =========================================================================== #
# The content of the .svg file will be put onto a Gtk::DrawingArea.
# =========================================================================== #
area = Gtk::DrawingArea.new
area.signal_connect(:draw) { |widget, _event|
  cairon_context = widget.window.create_cairo_context
  window_width, window_height = widget.window.width, widget.window.height
  cairon_context.scale(
    window_width.to_f  / width,
    window_height.to_f / height
  )
  cairon_context.render_rsvg_handle(handle)
}

window.add(area)
window.move(0, 0)
window.show_all
Gtk.main # svg_viewer /pig.svg