#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/vte/vte3_terminal.rb
# =========================================================================== #
require 'vte3'

# puts Vte.class

# =========================================================================== #
# === USE_THIS_FONT
# =========================================================================== #
USE_THIS_FONT = 'Monospace 22'

window = Gtk::Window.new('Terminal sample')
window.signal_connect(:destroy){ Gtk.main_quit }

terminal = Vte::Terminal.new
terminal.signal_connect(:child_exited) { |_widget|
  Gtk.main_quit
}
terminal.signal_connect(:window_title_changed) { |_widget|
  window.title = terminal.window_title
}
# =========================================================================== #
# API for .spawn_async() is:
#
#   pty_flags (Vte.PtyFlags) – flags from Vte.PtyFlags
#   working_directory (str or None) – the name of a directory the command should start in, or None to use the current working directory
#   argv ([str]) – child’s argument vector
#   envv ([str] or None) – a list of environment variables to be added to the environment before starting the process, or None
#
# =========================================================================== #
terminal.set_font(
  Pango::FontDescription.new(USE_THIS_FONT)
)
# terminal.spawn_async(
#   Vte::PtyFlags::DEFAULT,
#   '/root/',
#   ['/usr/bin/irb'],
#   ['X: 42']
# )
terminal.spawn

# @note_book = Gtk::Notebook.new
# @note_book.tab_reorderable = true if @note_book.respond_to?(:tab_reorderable=)
# @note_book.scrollable = true


#    self.spawn_async(
#      Vte.PtyFlags.DEFAULT, # Pty Flags
#      os.environ['HOME'], # Working DIR
#      ["/bin/bash"]
      
# terminal.spawn('irb')
window.add(terminal)
window.show_all
Gtk.main