#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk4/074_frame_example.rb
# =========================================================================== #
require 'gtk4'

# =========================================================================== #
# === SWITCH_TEXT
# =========================================================================== #
SWITCH_TEXT = 'switch here to (will use .reparent)'

# =========================================================================== #
# Use a specific font size next:
# =========================================================================== #
#::Gtk::Settings.default.gtk_font_name = 'Mono 22'

@box1 = Gtk::Box.new(:vertical, 0)

box2 = Gtk::Box.new(:horizontal, 5)
@box1.append(box2)

label = Gtk::Label.new('Hello World')
frame1 = Gtk::Frame.new('Frame 1')
box2.append(frame1)

@box3 = Gtk::Box.new(:vertical, 5)
frame1.set_child(@box3)

button = Gtk::Button.new(label: SWITCH_TEXT)
button.signal_connect(:clicked) { label.reparent(@box3) } # Do reparenting here.
@box3.append(button)
@box3.append(label)

frame2 = Gtk::Frame.new('Frame 2')
frame2.label_widget.set_selectable(true)
box2.append(frame2)

box4 = Gtk::Box.new(:vertical, 5)
frame2.set_child(box4)

button = Gtk::Button.new(label: SWITCH_TEXT)
button.signal_connect(:clicked) { label.reparent(box4) } # Do reparenting here.
box4.append(button)

separator = Gtk::Separator.new(:horizontal)
@box1.append(separator)

box2 = Gtk::Box.new(:horizontal, 10)
@box1.append(box2)

# =========================================================================== #
# Add the clost-button next.
# =========================================================================== #
button_close = Gtk::Button.new(label: 'close')
button_close.signal_connect(:clicked) { Gtk.main_quit }
box2.append(button_close)
box2.append(Gtk::Label.new('Also showing some button styles'))

@box3 = Gtk::Box.new(:vertical)
frame1 = Gtk::Frame.new
#frame1.shadow_type = Gtk::ShadowType::IN
label1 = Gtk::Label.new('Frame 1: Shadow type in')
frame1.set_child(label1)
@box3.append(frame1)

frame2 = Gtk::Frame.new
#frame2.shadow_type = Gtk::ShadowType::OUT
label2 = Gtk::Label.new('Frame 2: Shadow type out')
frame2.set_child(label2)
@box3.append(frame2)

frame3 = Gtk::Frame.new
#frame3.shadow_type = Gtk::ShadowType::ETCHED_IN

label3 = Gtk::Label.new('Frame 3: Shadow etched in')
frame3.set_child(label3)
@box3.append(frame3)

frame4 = Gtk::Frame.new
#frame4.shadow_type = Gtk::ShadowType::ETCHED_OUT
label4 = Gtk::Label.new('Frame 4: Shadow etched out')
frame4.set_child(label4)
@box3.append(frame4)

class MixedBox < Gtk::Box

  def initialize(box1, box2)
    super(:vertical)
    append(box1)
    append(box2)
  end

end

application = Gtk::Application.new('org.gtk.frame_example', :flags_none)
application.signal_connect(:activate) { |app|
  win = ::Gtk::ApplicationWindow.new(app)
  win.title = 'Showcasing Frame Example' 
  win.set_default_size(100, 100)
  win.set_child(MixedBox.new(@box1, @box3))
  win.show
}
application.run