#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TextViewExample
# =========================================================================== #
# $GTK_PARADISE/examples/gtk4/006_text_view_example.rb
# =========================================================================== #
require 'gtk4'

alias e puts

module Gtk

class TextViewExample < ::Gtk::Box # === Gtk::TextViewExample

  alias e puts

  # ========================================================================= #
  # === FILE
  #
  # FILE = '/test_file.md'
  # FILE = '/Depot/j/foo.md'
  # ========================================================================= #
  FILE = '/yo.yml'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:vertical)
    run
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    text_buffer = ::Gtk::TextBuffer.new
    text_buffer.set_text(
      "Hello world!\n"*100
    )
    # ======================================================================= #
    # The next line is for debugging-purposes on my home setup.
    # ======================================================================= #
    if File.exist? FILE
      text_buffer.set_text(File.read(FILE))
    end
    text_view = ::Gtk::TextView.new(text_buffer)
    text_view.set_size_request(1200, 800)
    scrolled_window = ::Gtk::ScrolledWindow.new
    scrolled_window.set_child(text_view)
    scrolled_window.set_size_request(800, 600)
    box = ::Gtk::Box.new(:vertical)
    box.append(
      ::Gtk::Label.new('Showing a TextView widget next:')
    )
    box.prepend(
      scrolled_window
    )
    box.append(
      ::Gtk::Separator.new(:horizontal)
    )
    append(box)
  end

end; end

application = Gtk::Application.new('org.gtk.tree_view_example', :flags_none)
application.signal_connect(:activate) { |app|
  win = ::Gtk::ApplicationWindow.new(app)
  win.title = 'Showcasing Text View Example' 
  win.set_default_size(100, 100)
  win.set_child(Gtk::TextViewExample.new)
  win.show
}
application.run