#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/002_scrolled_window_example.rb
# =========================================================================== #
require 'gtk4'

alias e puts

window = Gtk::Window.new

@text_buffer = Gtk::TextBuffer.new

@text_view = Gtk::TextView.new(@text_buffer)
@text_view.set_editable(true)

@text_view.cursor_visible = false
@text_view.wrap_mode = :word
@text_view.left_margin  = 25
@text_view.right_margin = 25
@text_view.set_cursor_visible(true)

@scrolled_window = Gtk::ScrolledWindow.new
@scrolled_window.set_child(@text_view)
@scrolled_window.set_policy(:always, :always)
# GtkEventControllerScroll
pp @scrolled_window.signal_connect(:event_controllers)

# controller = Gtk::GestureClick.new()
# controller.signal_connect(:pressed) { e 'Hello world!' }
# widget.add(controller)
#                            G_CALLBACK (click_cb), NULL);
# gtk_widget_add_controller (widget, controller);
#@scrolled_window.signal_connect(:controller_scroll) {|widget, event|
#e 'SCROLLING'
#}
#   _ = event.event_type.name.to_s
#   case _
#   when 'GDK_SCROLL' # Respond to scroll-events next.
#     e 'The widget received a scroll-event (:scroll_event).'
#     value = widget.vadjustment
#     e value
#     # vadj.set_value(ypos-80) 
#     # self.scrolled_window.set_vadjustment(vadj)
#   when 'GDK_BUTTON_PRESS'
#     e 'The left mouse-button was clicked! Selecting everything next.'
#     @text_view.signal_emit(:select_all, event)
#   end
# }

window.set_size_request(1200, 800)

application = Gtk::Application.new('org.gtk.example2', :flags_none)
application.signal_connect(:activate) { |app|
  win = Gtk::ApplicationWindow.new(app)
  win.title = 'A gtk-scrolling example' 
  win.set_default_size(1220, 600)
  win.set_child(@scrolled_window)
  win.show
}
application.run