#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk4/101_actionbar_example.rb
# =========================================================================== #
# Note that this example doesn't work correctly right now.
# =========================================================================== #
require 'gtk4'

application = Gtk::Application.new('org.gtk.actionbar_example', :flags_none)

def on_button_clicked
  puts 'I was clicked.'
end

application.signal_connect(:activate) { |app|
  win = Gtk::ApplicationWindow.new(app)
  win.title = 'Actionbar Example'
  win.set_default_size(1200, 600)

  actionbar = Gtk::ActionBar.new
  actionbar.set_valign(Gtk::Align::END)
  actionbar.set_vexpand(expand = true)
  # Populate the actionbar next:

  icons = %w(
    call-start-symbolic
    call-stop-symbolic
    contact-new-symbolic
    address-book-new-symbolic
    /home/x/data/images/NJOY/SmilingLady.jpg
  )

  icons.each {|icon|
    if File.exist? icon
      button = Gtk::Button.new
      button.set_child(Gtk::Image.new(file: icon))
    else
      button = Gtk::Button.new(stock_id: icon)
    end
    button.signal_connect(:clicked) { on_button_clicked }
    actionbar.pack_start(child = button)
  }

  vbox = Gtk::Box.new(:vertical)
  vbox.prepend(
    actionbar
  )
  win.set_child(vbox)
  win.show
  win.set_size_request(200, 800)
}

application.run