#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk4/102_picture_example.rb
# =========================================================================== #
# Since as of gtk4 Gtk::Picture is a new class.
# =========================================================================== #
require 'gtk4'

application = Gtk::Application.new('org.gtk.picture_example', :flags_none)

# =========================================================================== #
# === USE_THIS_FILE
# =========================================================================== #
USE_THIS_FILE = '/home/x/data/images/NJOY/SomeD.jpg'


application.signal_connect(:activate) { |app|
  win = Gtk::ApplicationWindow.new(app)
  win.title = 'Picture Example'
  win.set_default_size(1200, 600)

  vbox = Gtk::Box.new(:vertical)
  picture = Gtk::Picture.new
  #pp picture.methods.sort
  picture.filename = USE_THIS_FILE
  picture.set_keep_aspect_ratio(true)
  vbox.prepend(picture)
  win.set_child(vbox)
  win.show
  win.set_size_request(800, 800)
}

application.run