#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk4'

module Gtk

class QuitOnKeypressEvent < ::Gtk::Box # === Gtk::QuitOnKeypressEvent

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:horizontal)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === title?
  # ========================================================================= #
  def title?
    'Cahnged Events Example'
  end; alias title title? # === title

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    keycont = Gtk::EventControllerKey.new
    keycont.signal_connect(:key_pressed) {|widget, event|
      e 'WE WERE PRESSED!'
      pp event
    }
    add_controller(keycont)
    set_halign(:center)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  alias e puts
  application = Gtk::Application.new('org.gtk.changed_events_example', :flags_none)
  application.signal_connect(:activate) { |app|
    win = Gtk::ApplicationWindow.new(app)
    win.title = 'Showcasing Events' 
    win.set_default_size(600, 200)
    win.set_child(Gtk::QuitOnKeypressEvent.new)
    win.signal_connect(:close_request) {
      e 'Exiting now.'
    }
    win.show
  }
  application.run
end