#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

class PangoPower

  # ========================================================================= #
  # === TEXT
  # ========================================================================= #
  TEXT = "Pango power!\nPango power!\nPango power!"

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    @window = Gtk::Window.new(:toplevel)
    @window.resizable = true
    @window.set_size_request(680, 280)
    @window.title = "Text Mask"

    da = Gtk::DrawingArea.new

    @window.add(da)

    da.signal_connect(:draw) { |_widget, cr|
      cr.save

      layout = da.create_pango_layout(TEXT)
      desc = Pango::FontDescription.new("sans bold 45")
      layout.font_description = desc

      cr.move_to(30, 20)
      cr.pango_layout_path(layout)

      pattern = Cairo::LinearPattern.new(0.0, 0.0,
                                         da.allocated_width,
                                         da.allocated_height)

      pattern.add_color_stop(0.0, 1.0, 0.0, 0.0)
      pattern.add_color_stop(0.2, 1.0, 0.0, 0.0)
      pattern.add_color_stop(0.3, 1.0, 1.0, 0.0)
      pattern.add_color_stop(0.4, 0.0, 1.0, 0.0)
      pattern.add_color_stop(0.6, 0.0, 1.0, 1.0)
      pattern.add_color_stop(0.7, 0.0, 0.0, 1.0)
      pattern.add_color_stop(0.8, 1.0, 0.0, 1.0)
      pattern.add_color_stop(1.0, 1.0, 0.0, 1.0)
      cr.set_source(pattern)
      cr.fill_preserve

      cr.set_source_rgb(0.0, 0.0, 0.0)
      cr.set_line_width(0.5)
      cr.stroke
      cr.restore
      true
    }
    run
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    if !@window.visible?
      @window.show_all
    else
      @window.destroy
    end
    @window.move(0, 0)
    Gtk.main
  end

end

if __FILE__ == $PROGRAM_NAME
  PangoPower.new
end