#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === RubyApp
#
# This will just include some experiments in gtk3.
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

class RubyApp < ::Gtk::Window

  require 'gtk_paradise/widgets/version_agnostic/button_open_remote_webpage.rb'
  require 'gtk_paradise/widgets/version_agnostic/numbers_only.rb'

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  require 'gtk_paradise/run_module/run_module.rb'
  include ::Gtk::RunModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Experimental stuff for ruby-gtk3'

  # ========================================================================= #
  # === USE_THIS_IMAGE
  # ========================================================================= #
  USE_THIS_IMAGE = 
    Gtk.project_base_directory?+'images/misc/sample_image.png'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '80%'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '50%'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super()
    reset
    set_title TITLE
    signal_destroy_then_quit
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === width, title and height
    # ======================================================================= #
    width_title_height(WIDTH, TITLE, HEIGHT)
    # ======================================================================= #
    # We can choose from different fonts, including symbol-representations
    # such as :hack_25.
    # ======================================================================= #
    set_font_size :chandas_22
    set_border_width(10)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === on_button_toggled
  # ========================================================================= #
  def on_button_toggled(button, name)
    state = button.active? ? 'on' : 'off'
    e "Button #{name} was turned #{state}"
  end

  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
    # vbox = ::Gtk::Box.new(:vertical)
    vbox = padded_vbox
    button_say_hello = button(label: 'Say hello')
    button_say_hello.on_clicked { |_widget|
      e 'Hello World!! \\o/'
    }
    button_say_hello.hint = 'Hello world!'
    button_say_hello.override_font(Pango::FontDescription.new('bold'))
    vbox.maximal(button_say_hello)
    vbox.add(label('An example-label.'))
    vbox.add(bold('Another one, but in bold.'))
    label = label('Say hello')
    label.set_text(
      Gtk.resolution?.first.to_s+' : '+
      Gtk.resolution?.last.to_s
    )
    vbox.minimal(label)
    vbox.minimal(gtk_spacer)
    
    check_button = check_button('Cat or Dog')
    vbox.minimal(check_button)
    bold_actionless_button = bold_button('A bold button without action')
    bold_actionless_button.remove_background
    bold_actionless_button.css_class('lightgreen BG_Black')
    vbox.minimal(bold_actionless_button)
    an_expander = gtk_expander('Expander Sample')
    an_expander.expanded = true
    button = gtk_button('Hide this button.')
    button.on_clicked {
      an_expander.expanded = false # If the button si clicked, gtk-expander will hide it again.
    }
    button.set_size_request(300, 300)
    an_expander.add(button)
    vbox.pack_start(an_expander)
    label = bold_label('Another test - this text can be selected!')
    label.align_left
    label.make_selectable
    vbox.minimal(label)
    hbox = gtk_hbox
    button1 = Gtk::RadioButton.new(label: 'Button 1')
    button1.on_toggled { |b| on_button_toggled b, 1 }
    button2 = Gtk::RadioButton.new(member: button1, label: 'Button 2')
    button2.on_toggled { |b| on_button_toggled b, 2 }
    hbox.maximal(button1)
    hbox.maximal(button2)
    vbox.minimal(hbox)
    vbox.minimal(gtk_spacer)
    # ======================================================================= #
    # Testing Gtk::Entry next.
    # ======================================================================= #
    if ::Gtk.respond_to? :input_field
      input_field = ::Gtk.input_field
      # input_field.align_to_the_right # Just to test this.
      input_field.append_text('😎️' + '▄' * 5)
      vbox.pack_start(input_field)
    end
    # ======================================================================= #
    # Add a test button, via a gtk-frame, in another font.
    # ======================================================================= #
    button_test = gtk_button(
      'A test button (debug) inside the Gtk::Frame, using the font EmojiOne'
    )
    button_test.use_this_font = 'EmojiOne Color 22'
    button_test.on_clicked {
      debug
    }
    frame = gtk_bold_frame('Hey there! This is a frame.')
    frame.add(button_test) # Add the test-button next.
    vbox.pack_start(frame)
    vbox.pack_minimal(gtk_label(smiley2))
    clickable_label = gtk_label('Now a small widget that can be clicked')
    clickable_label.enable_on_click_actions
    vbox.pack_minimal(
      clickable_label
    )
    label = gtk_label('Hey there - this is just a label. It can not be selected. :(')
    label.set_name('background_colour_navajowhite')
    vbox.pack_start(label)
    numbers_only = Gtk::NumbersOnly.new
    vbox.pack_start(numbers_only)

    vbox.pack_start(
      Gtk.hscale( n_digits: 6 ) # Show n digits here.
    )
    button_for_popup_window = gtk_button('click this for a popup-window (Font is Samanata 25)')
    button_for_popup_window.use_this_font = 'Samanata 25'
    button_for_popup_window.lightgreen
    button_for_popup_window.on_clicked {
      e 'Trying to open a window.'
      Gtk.popup_window
    }
    vbox.minimal(button_for_popup_window)
    # ========================================================================= #
    # Try the remote-webpage button next.
    # ========================================================================= #
    # vbox.pack_minimal(::Gtk::ButtonOpenRemoteWebpage.new)
    
    # ========================================================================= #
    # Put it into a scrolled-window next.
    # ========================================================================= #
    scrolled_window = gtk_scrolled_window(vbox) { :always_scrollbars }
    add(scrolled_window)
    move(0, 0)
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    create_skeleton
    show_all
    top_left
    enable_simple_exit
    show_CSS_in_use
  end

end

if __FILE__ == $PROGRAM_NAME
  RubyApp.new
  #require 'gtk_paradise/run'
  #r = Gtk.run
  #r << ruby_app
  Gtk.enable_default_css
  Gtk.main
  #r.run
end # fixed_example.rb

__END__

if __FILE__ == $PROGRAM_NAME

  @app.signal_connect(:activate) { |a|
    w = Gtk::ApplicationWindow.new(a)
    w.move(0, 0)
    w.set_title('XFCE Colour')
    w.set_icon(
      IMAGE_TO_USE
    )
    w.set_default_size(80, 80)
    w.add(Gtk::Experimental.new)
    w.show_all
  }
  @app.run

end # exp