#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/fonts/fonts.rb'
# Gtk.expand_this_font
# Gtk.set_font('Sans 28')
# =========================================================================== #
module Gtk

  require 'gtk_paradise/constants/constants.rb'

  # ========================================================================= #
  # === Gtk.set_font
  #
  # This is simply a simpler variant over Gtk::Settings.default.gtk_font_name.
  #
  # You normally most likely won't need this, as there are other methods
  # to modify the font in a gtk-application.
  # ========================================================================= #
  def self.set_font(
      i = 'Sans 26'
    )
    ::Gtk::Settings.default.gtk_font_name = i
  end; self.instance_eval { alias font= set_font } # === Gtk.font=

  # ========================================================================= #
  # === Gtk.expand_this_font
  #
  # This method is specifically optimised for symbols as input, such as
  # :hack_25. I found them easier to type, which is why I started to
  # make use of them.
  # ========================================================================= #
  def self.expand_this_font(
      i = :default
    )
    case i # case tag
    # ======================================================================= #
    # === :dejavu_15
    # ======================================================================= #
    when :dejavu_15,
         :dejagnu_15,
         :deja_vu_15
      i = 'DejaVu Sans 15'
    # ======================================================================= #
    # === :dejavu_16
    # ======================================================================= #
    when :dejavu_16,
         :dejagnu_16
      i = 'DejaVu Sans 16'
    # ======================================================================= #
    # === :dejavu_17
    # ======================================================================= #
    when :dejavu_17,
         :dejagnu_17
      i = 'DejaVu Sans 17'
    # ======================================================================= #
    # === :dejavu_18
    # ======================================================================= #
    when :dejavu_18,
         :dejagnu_18
      i = 'DejaVu Sans 18'
    # ======================================================================= #
    # === :dejavu_19
    # ======================================================================= #
    when :dejavu_19,
         :dejagnu_19
      i = 'DejaVu Sans 19'
    # ======================================================================= #
    # === :dejavu_20
    # ======================================================================= #
    when :dejavu_20,
         :dejagnu_20
      i = 'DejaVu Sans 20'
    # ======================================================================= #
    # === :dejavu_22
    # ======================================================================= #
    when :dejavu_22,
         :dejagnu_22
      i = 'DejaVu Sans 22'
    # ======================================================================= #
    # === :dejavu_20
    # ======================================================================= #
    when :dejavu_25,
         :deja_vu_sans_25
      i = 'DejaVu Sans 25'
    # ======================================================================= #
    # === :cantarell_bold_11
    # ======================================================================= #
    when :cantarell_bold_11
      i = 'Cantarell Bold 11'
    # ======================================================================= #
    # === :cantarell_bold_12
    # ======================================================================= #
    when :cantarell_bold_12
      i = 'Cantarell Bold 12'
    # ======================================================================= #
    # === :cantarell_bold_13
    # ======================================================================= #
    when :cantarell_bold_13
      i = 'Cantarell Bold 13'
    # ======================================================================= #
    # === :cantarell_bold_14
    # ======================================================================= #
    when :cantarell_bold_14
      i = 'Cantarell Bold 14'
    # ======================================================================= #
    # === :cantarell_bold_15
    # ======================================================================= #
    when :cantarell_bold_15
      i = 'Cantarell Bold 15'
    # ======================================================================= #
    # === :dejavu_condensed_10
    # ======================================================================= #
    when :dejavu_condensed_10
      i = 'DejaVu Serif Condensed 10'
    # ======================================================================= #
    # === :dejavu_condensed_11
    # ======================================================================= #
    when :dejavu_condensed_11
      i = 'DejaVu Serif Condensed 11'
    # ======================================================================= #
    # === :dejavu_condensed_12
    # ======================================================================= #
    when :dejavu_condensed_12
      i = 'DejaVu Serif Condensed 12'
    # ======================================================================= #
    # === :dejavu_condensed_13
    # ======================================================================= #
    when :dejavu_condensed_13
      i = 'DejaVu Serif Condensed 13'
    # ======================================================================= #
    # === :dejavu_condensed_14
    # ======================================================================= #
    when :dejavu_condensed_14
      i = 'DejaVu Serif Condensed 14'
    # ======================================================================= #
    # === :dejavu_condensed_15
    # ======================================================================= #
    when :dejavu_condensed_15
      i = 'DejaVu Serif Condensed 15'
    # ======================================================================= #
    # === :dejavu_condensed_16
    # ======================================================================= #
    when :dejavu_condensed_16
      i = 'DejaVu Serif Condensed 16'
    # ======================================================================= #
    # === :dejavu_condensed_17
    # ======================================================================= #
    when :dejavu_condensed_17
      i = 'DejaVu Serif Condensed 17'
    # ======================================================================= #
    # === :dejavu_condensed_18
    # ======================================================================= #
    when :dejavu_condensed_18
      i = 'DejaVu Serif Condensed 18'
    # ======================================================================= #
    # === :dejavu_condensed_19
    # ======================================================================= #
    when :dejavu_condensed_19
      i = 'DejaVu Serif Condensed 19'
    # ======================================================================= #
    # === :dejavu_condensed_20
    # ======================================================================= #
    when :dejavu_condensed_20
      i = 'DejaVu Serif Condensed 20'
    # ======================================================================= #
    # === :dejavu_condensed_21
    # ======================================================================= #
    when :dejavu_condensed_21
      i = 'DejaVu Serif Condensed 21'
    # ======================================================================= #
    # === :dejavu_condensed_22
    # ======================================================================= #
    when :dejavu_condensed_22
      i = 'DejaVu Serif Condensed 22'
    # ======================================================================= #
    # === :dejavu_condensed_23
    # ======================================================================= #
    when :dejavu_condensed_23
      i = 'DejaVu Serif Condensed 23'
    # ======================================================================= #
    # === :dejavu_condensed_24
    # ======================================================================= #
    when :dejavu_condensed_24
      i = 'DejaVu Serif Condensed 24'
    # ======================================================================= #
    # === :dejavu_condensed_25
    # ======================================================================= #
    when :dejavu_condensed_25
      i = 'DejaVu Serif Condensed 25'
    # ======================================================================= #
    # === :dejavu_condensed_26
    # ======================================================================= #
    when :dejavu_condensed_26
      i = 'DejaVu Serif Condensed 26'
    # ======================================================================= #
    # === :dejavu_condensed_27
    # ======================================================================= #
    when :dejavu_condensed_27
      i = 'DejaVu Serif Condensed 27'
    # ======================================================================= #
    # === :dejavu_condensed_28
    # ======================================================================= #
    when :dejavu_condensed_28
      i = 'DejaVu Serif Condensed 28'
    # ======================================================================= #
    # === :dejavu_condensed_29
    # ======================================================================= #
    when :dejavu_condensed_29
      i = 'DejaVu Serif Condensed 29'
    # ======================================================================= #
    # === :dejavu_condensed_30
    # ======================================================================= #
    when :dejavu_condensed_30
      i = 'DejaVu Serif Condensed 30'
    # ======================================================================= #
    # === :dejavu_condensed_31
    # ======================================================================= #
    when :dejavu_condensed_31
      i = 'DejaVu Serif Condensed 31'
    # ======================================================================= #
    # === :dejavu_condensed_32
    # ======================================================================= #
    when :dejavu_condensed_32
      i = 'DejaVu Serif Condensed 32'
    # ======================================================================= #
    # === :dejavu_condensed_33
    # ======================================================================= #
    when :dejavu_condensed_33
      i = 'DejaVu Serif Condensed 33'
    # ======================================================================= #
    # === :dejavu_condensed_34
    # ======================================================================= #
    when :dejavu_condensed_34
      i = 'DejaVu Serif Condensed 34'
    # ======================================================================= #
    # === :dejavu_condensed_35
    # ======================================================================= #
    when :dejavu_condensed_35
      i = 'DejaVu Serif Condensed 35'
    # ======================================================================= #
    # === :dejavu_condensed_50
    # ======================================================================= #
    when :dejavu_condensed_50
      i = 'DejaVu Serif Condensed 50'
    # ======================================================================= #
    # === :noto_mono_18
    # ======================================================================= #
    when :noto_mono_18
      i = 'Noto Mono 18'
    # ======================================================================= #
    # === :noto_mono_19
    # ======================================================================= #
    when :noto_mono_19
      i = 'Noto Mono 19'
    # ======================================================================= #
    # === :noto_mono_20
    # ======================================================================= #
    when :noto_mono_20
      i = 'Noto Mono 20'
    # ======================================================================= #
    # === :noto_mono_21
    # ======================================================================= #
    when :noto_mono_21
      i = 'Noto Mono 21'
    # ======================================================================= #
    # === :noto_mono_22
    # ======================================================================= #
    when :noto_mono_22
      i = 'Noto Mono 22'
    # ======================================================================= #
    # === :noto_mono_23
    # ======================================================================= #
    when :noto_mono_23
      i = 'Noto Mono 23'
    # ======================================================================= #
    # === :noto_mono_24
    # ======================================================================= #
    when :noto_mono_24
      i = 'Noto Mono 24'
    # ======================================================================= #
    # === :noto_mono_25
    # ======================================================================= #
    when :noto_mono_25
      i = 'Noto Mono 25'
    # ======================================================================= #
    # === :hack_5
    # ======================================================================= #
    when :hack_5
      i = 'Hack 5'
    # ======================================================================= #
    # === :hack_6
    # ======================================================================= #
    when :hack_6
      i = 'Hack 6'
    # ======================================================================= #
    # === :hack_7
    # ======================================================================= #
    when :hack_7
      i = 'Hack 7'
    # ======================================================================= #
    # === :hack_8
    # ======================================================================= #
    when :hack_8
      i = 'Hack 8'
    # ======================================================================= #
    # === :hack_9
    # ======================================================================= #
    when :hack_9
      i = 'Hack 9'
    # ======================================================================= #
    # === :hack_10
    # ======================================================================= #
    when :hack_10
      i = 'Hack 10'
    # ======================================================================= #
    # === :hack_11
    # ======================================================================= #
    when :hack_11
      i = 'Hack 11'
    # ======================================================================= #
    # === :hack_12
    # ======================================================================= #
    when :hack_12
      i = 'Hack 12'
    # ======================================================================= #
    # === :hack_13
    # ======================================================================= #
    when :hack_13
      i = 'Hack 13'
    # ======================================================================= #
    # === :hack_14
    # ======================================================================= #
    when :hack_14
      i = 'Hack 14'
    # ======================================================================= #
    # === :hack_15
    # ======================================================================= #
    when :hack_15
      i = 'Hack 15'
    # ======================================================================= #
    # === :hack_16
    # ======================================================================= #
    when :hack_16
      i = 'Hack 16'
    # ======================================================================= #
    # === :hack_17
    # ======================================================================= #
    when :hack_17
      i = 'Hack 17'
    # ======================================================================= #
    # === :hack
    # ======================================================================= #
    when :hack_18,
         :hack18,
         :hack
      i = 'Hack 18'
    # ======================================================================= #
    # === :hack
    # ======================================================================= #
    when :hack_19
      i = 'Hack 19'
    # ======================================================================= #
    # === :hack
    # ======================================================================= #
    when :hack_20
      i = 'Hack 20'
    # ======================================================================= #
    # === :hack
    # ======================================================================= #
    when :hack_21
      i = 'Hack 21'
    # ======================================================================= #
    # === :hack
    # ======================================================================= #
    when :hack_22
      i = 'Hack 22'
    # ======================================================================= #
    # === :hack
    # ======================================================================= #
    when :hack_23
      i = 'Hack 23'
    # ======================================================================= #
    # === :hack
    # ======================================================================= #
    when :hack_24
      i = 'Hack 24'
    # ======================================================================= #
    # === :hack_25
    # ======================================================================= #
    when :hack_25
      i = 'Hack 25'
    # ======================================================================= #
    # === :hack_26
    # ======================================================================= #
    when :hack_26
      i = 'Hack 26'
    # ======================================================================= #
    # === :hack_27
    # ======================================================================= #
    when :hack_27
      i = 'Hack 27'
    # ======================================================================= #
    # === :hack_28
    # ======================================================================= #
    when :hack_28
      i = 'Hack 28'
    # ======================================================================= #
    # === :hack_29
    # ======================================================================= #
    when :hack_29
      i = 'Hack 29'
    # ======================================================================= #
    # === :hack_30
    # ======================================================================= #
    when :hack_30
      i = 'Hack 30'
    # ======================================================================= #
    # === :hack_35
    # ======================================================================= #
    when :hack_35
      i = 'Hack 35'
    # ======================================================================= #
    # === :hack_50
    # ======================================================================= #
    when :hack_50
      i = 'Hack 50'
    # ======================================================================= #
    # === :cantarell_20
    # ======================================================================= #
    when :cantarell_20
      i = 'Cantarell 20'
    # ======================================================================= #
    # === :cantarell_21
    # ======================================================================= #
    when :cantarell_21
      i = 'Cantarell 21'
    # ======================================================================= #
    # === :cantarell_22
    # ======================================================================= #
    when :cantarell_22
      i = 'Cantarell 22'
    # ======================================================================= #
    # === :cantarell_23
    # ======================================================================= #
    when :cantarell_23
      i = 'Cantarell 23'
    # ======================================================================= #
    # === :cantarell_24
    # ======================================================================= #
    when :cantarell_24
      i = 'Cantarell 24'
    # ======================================================================= #
    # === :cantarell_25
    # ======================================================================= #
    when :cantarell_25
      i = 'Cantarell 25'
    # ======================================================================= #
    # === :mono
    # ======================================================================= #
    when :mono
      i = 'Mono 18'
    # ======================================================================= #
    # === :liberation
    # ======================================================================= #
    when :liberation,
         :liberation_mono
      i = 'Liberation Mono 18'
    # ======================================================================= #
    # === :mono_20
    # ======================================================================= #
    when :mono_20
      i = 'Liberation Mono 20'
    # ======================================================================= #
    # === :mono_21
    # ======================================================================= #
    when :mono_21
      i = 'Liberation Mono 21'
    # ======================================================================= #
    # === :mono_22
    # ======================================================================= #
    when :mono_22
      i = 'Liberation Mono 22'
    # ======================================================================= #
    # === :mono_23
    # ======================================================================= #
    when :mono_23
      i = 'Liberation Mono 23'
    # ======================================================================= #
    # === :mono_24
    # ======================================================================= #
    when :mono_24
      i = 'Liberation Mono 24'
    # ======================================================================= #
    # === :mono_25
    # ======================================================================= #
    when :mono_25
      i = 'Liberation Mono 25'
    # ======================================================================= #
    # === :dejavu_sans_mono_25
    # ======================================================================= #
    when :dejavu_sans_mono_25
      i = 'DejaVu Sans Mono 25'
    # ======================================================================= #
    # === :dejavu_sans_mono_26
    # ======================================================================= #
    when :dejavu_sans_mono_26
      i = 'DejaVu Sans Mono 26'
    # ======================================================================= #
    # === :dejavu_sans_mono_27
    # ======================================================================= #
    when :dejavu_sans_mono_27
      i = 'DejaVu Sans Mono 27'
    # ======================================================================= #
    # === :dejavu_sans_mono_28
    # ======================================================================= #
    when :dejavu_sans_mono_28
      i = 'DejaVu Sans Mono 28'
    # ======================================================================= #
    # === :dejavu_sans_mono_29
    # ======================================================================= #
    when :dejavu_sans_mono_29
      i = 'DejaVu Sans Mono 29'
    # ======================================================================= #
    # === :dejavu_sans_mono_30
    # ======================================================================= #
    when :dejavu_sans_mono_30
      i = 'DejaVu Sans Mono 30'
    # ======================================================================= #
    # === :liberation_serif_20
    # ======================================================================= #
    when :liberation_serif_20
      i = 'Liberation Serif 20'
    # ======================================================================= #
    # === :liberation_serif_22
    # ======================================================================= #
    when :liberation_serif_22
      i = 'Liberation Serif 22'
    # ======================================================================= #
    # === :liberation_serif_25
    # ======================================================================= #
    when :liberation_serif_25
      i = 'Liberation Serif 25'
    # ======================================================================= #
    # === :liberation_serif_28
    # ======================================================================= #
    when :liberation_serif_28
      i = 'Liberation Serif 28'
    # ======================================================================= #
    # === :liberation_serif_30
    # ======================================================================= #
    when :liberation_serif_30
      i = 'Liberation Serif 30'
    # ======================================================================= #
    # === :source_code_pro_15
    # ======================================================================= #
    when :source_code_pro_15
      i = 'Source Code Pro 15'
    # ======================================================================= #
    # === :source_code_pro_16
    # ======================================================================= #
    when :source_code_pro_16
      i = 'Source Code Pro 16'
    # ======================================================================= #
    # === :source_code_pro_17
    # ======================================================================= #
    when :source_code_pro_17
      i = 'Source Code Pro 17'
    # ======================================================================= #
    # === :source_code_pro_18
    # ======================================================================= #
    when :source_code_pro_18
      i = 'Source Code Pro 18'
    # ======================================================================= #
    # === :source_code_pro_19
    # ======================================================================= #
    when :source_code_pro_19
      i = 'Source Code Pro 19'
    # ======================================================================= #
    # === :source_code_pro_20
    # ======================================================================= #
    when :source_code_pro_20
      i = 'Source Code Pro 20'
    # ======================================================================= #
    # === :source_code_pro_21
    # ======================================================================= #
    when :source_code_pro_21
      i = 'Source Code Pro 21'
    # ======================================================================= #
    # === :source_code_pro_22
    # ======================================================================= #
    when :source_code_pro_22
      i = 'Source Code Pro 22'
    # ======================================================================= #
    # === :source_code_pro_23
    # ======================================================================= #
    when :source_code_pro_23
      i = 'Source Code Pro 23'
    # ======================================================================= #
    # === :source_code_pro_24
    # ======================================================================= #
    when :source_code_pro_24
      i = 'Source Code Pro 24'
    # ======================================================================= #
    # === :source_code_pro_25
    # ======================================================================= #
    when :source_code_pro_25
      i = 'Source Code Pro 25'
    # ======================================================================= #
    # === :chandas_20
    # ======================================================================= #
    when :chandas_20
      i = 'Chandas 20'
    # ======================================================================= #
    # === :chandas_22
    # ======================================================================= #
    when :chandas_22
      i = 'Chandas 22'
    # ======================================================================= #
    # === :chandas_23
    # ======================================================================= #
    when :chandas_23
      i = 'Chandas 23'
    # ======================================================================= #
    # === :chandas_24
    # ======================================================================= #
    when :chandas_24
      i = 'Chandas 24'
    # ======================================================================= #
    # === :chandas_25
    # ======================================================================= #
    when :chandas_25
      i = 'Chandas 25'
    # ======================================================================= #
    # === :chandas_30
    # ======================================================================= #
    when :chandas_30
      i = 'Chandas 30'
    # ======================================================================= #
    # === :chandas_40
    # ======================================================================= #
    when :chandas_40
      i = 'Chandas 40'
    # ======================================================================= #
    # === :frank_ruhl_hofshi_22
    # ======================================================================= #
    when :frank_ruhl_hofshi_22
      i = 'Frank Ruhl Hofshi 22'
    # ======================================================================= #
    # === :default
    #
    # This variant will tap into the default font to use.
    # ======================================================================= #
    when :default
      i = USE_THIS_FONT
    else
      if i.is_a? Integer
        i = "#{USE_THIS_FONT_FAMILY_FOR_GUI_APPLICATIONS} #{i}"
      else
        # =================================================================== #
        # === Handle Symbols next:
        # =================================================================== #
        if i.is_a? Symbol
          if i.to_s.include?('_')
            # =============================================================== #
            # So we have a Symbol that looks like this: :liberation_serif_20.
            # We will next handle the splittable input:
            # =============================================================== #
            splitted = i.to_s.split('_') # e. g. :liberation_serif_22
            splitted[0] = splitted[0].capitalize
            splitted[1] = splitted[1].capitalize
            i = splitted.join(' ')
          else
            puts "The symbol-argument for a font (#{i}) was not found."
          end
        end
      end
    end
    return i
  end

end