#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# Note that this will directly modify module Gdk, so make sure you want
# this or don't mind this, before requiring this file.
# =========================================================================== #
# require 'gtk_paradise/gdk/cursor.rb'
# =========================================================================== #
module Gdk

class Cursor # === Gdk::Cursor

  # ========================================================================= #
  # === Gdk::Cursor.available_cursors?
  # ========================================================================= #
  def self.available_cursors?
    Cursor.constants.sort
  end

end; end

if __FILE__ == $PROGRAM_NAME
  # ========================================================================= #
  # This here is solely testing-related code. We have to require gtk2
  # early, because we re-define Gdk::Cursor in this .rb file here.
  # ========================================================================= #
  require 'gtk2' # This should actually happen before ...
  pp Gdk::Cursor.available_cursors?
end