#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Pango::Fonts
#
# Some Pango fonts. Note that this is mostly legacy code; I rarely make
# use of these constants nowadays, simply because a case/when menu
# handles this in a more elegant manner. Nonetheless for some ruby-gtk2
# legacy applications this file may still be useful.
#
# To use it, try:
#
#   include Gtk::PangoFonts
#
# or
#
#   PangoFonts::FONT_SANS_BOLD_08
#
# =========================================================================== #
# require 'gtk_paradise/pango/fonts.rb'
# =========================================================================== #
module Pango

module Fonts # === Pango::Fonts

if ::Pango.const_defined? :FontDescription

  # ========================================================================= #
  # === Font Sans bold
  # ========================================================================= #
  FONT_SANS_BOLD_08 = Pango::FontDescription.new('Sans Bold 08')
  FONT_SANS_BOLD_10 = Pango::FontDescription.new('Sans Bold 10')
  FONT_SANS_BOLD_11 = Pango::FontDescription.new('Sans Bold 11')
  FONT_SANS_BOLD_12 = Pango::FontDescription.new('Sans Bold 12')
  FONT_SANS_BOLD_14 = Pango::FontDescription.new('Sans Bold 14')
  FONT_SANS_BOLD_16 = Pango::FontDescription.new('Sans Bold 16')
  FONT_SANS_BOLD_18 = Pango::FontDescription.new('Sans Bold 18')
  FONT_SANS_BOLD_20 = Pango::FontDescription.new('Sans Bold 20')
  FONT_SANS_BOLD_22 = Pango::FontDescription.new('Sans Bold 22')

  # ========================================================================= #
  # === Font Utopia
  # ========================================================================= #
  FONT_UTOPIA_14 = Pango::FontDescription.new('Utopia 14')
  FONT_UTOPIA_16 = Pango::FontDescription.new('Utopia 16')
  FONT_UTOPIA_18 = Pango::FontDescription.new('Utopia 18')
  FONT_UTOPIA_20 = Pango::FontDescription.new('Utopia 20')

end; end; end