#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/requires/require_gtk3_or_gtk4.rb'
# Gtk.require_gtk2_or_gtk3_or_gtk4 :gtk3
# Gtk.we_use_this_gtk_version = :gtk2
# Gtk.we_use_this_gtk_version = :gtk3
# Gtk.we_use_this_gtk_version = :gtk4
# =========================================================================== #
module Gtk

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === DEFAULT_GTK_VERSION_TO_USE
  #
  # Specify which is the default-gtk version to use. This is gtk3 right now.
  # ========================================================================= #
  DEFAULT_GTK_VERSION_TO_USE = :gtk3

  # ========================================================================= #
  # === Gtk.do_load_the_default_gtk_version
  # ========================================================================= #
  def self.do_load_the_default_gtk_version
    if use_gtk4?
      require 'gtk4'
    elsif use_gtk3?
      require 'gtk3'
    end
  end

  # ========================================================================= #
  # === Gtk.require_gtk2_or_gtk3_or_gtk4
  #
  # Since as of November 2020, ruby-gtk3 is the default. If you do not
  # want this then it is recommended to ignore this method, and directly
  # require the gtk2.rb or gtk3.rb file.
  #
  # Invocation examples:
  #
  #   Gtk.require_gtk2_or_gtk3 :default
  #   Gtk.require_gtk2_or_gtk3 :gtk2
  #   Gtk.require_gtk2_or_gtk3 :gtk3
  #   Gtk.require_gtk2_or_gtk3 :gtk4
  #
  # ========================================================================= #
  def self.require_gtk2_or_gtk3_or_gtk4(
      require_which_version = :default
    )
    case require_which_version
    # ======================================================================= #
    # === :gtk4
    # ======================================================================= #
    when :gtk4
      require 'gtk4' # ← Require gtk4 here.
      ::Gtk.we_use_this_gtk_version = :gtk4
    # ======================================================================= #
    # === :gtk3
    #
    # ruby-gtk3 is still the default for the time being, at the least
    # as of September 2022.
    # ======================================================================= #
    when :gtk3,
         :default
      require 'gtk3' # ← Require gtk3 here.
      ::Gtk.we_use_this_gtk_version = :gtk3
      ::Gtk.init # This is no longer needed in ruby-gtk4, I think.
    # ======================================================================= #
    # === :gtk2
    # ======================================================================= #
    when :gtk2
      require 'gtk2' # ← Require gtk2 here.
      ::Gtk.we_use_this_gtk_version = :gtk2
      ::Gtk.init
    end
  end

  # ========================================================================= #
  # === Gtk.require_gtk2
  #
  # This variant is guaranteed to require gtk2.
  # ========================================================================= #
  def self.require_gtk2
     Gtk.require_gtk2_or_gtk3_or_gtk4(:gtk2)
  end

  # ========================================================================= #
  # === Gtk.require_gtk3
  #
  # This variant is guaranteed to require gtk3.
  # ========================================================================= #
  def self.require_gtk3
     Gtk.require_gtk2_or_gtk3_or_gtk4(:gtk3)
  end

  # ========================================================================= #
  # === Gtk.require_gtk4
  #
  # This variant is guaranteed to require gtk4.
  # ========================================================================= #
  def self.require_gtk4
     Gtk.require_gtk2_or_gtk3_or_gtk4(:gtk4)
  end

end